
#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>
#include <openplx/AnalysisContext.h>

namespace openplx {
    /**
     * Set's the type of all left hand side var assignments
     */
    class BindLhsTypesVisitor : private NodeVisitor {
        public:
            BindLhsTypesVisitor(std::shared_ptr<ErrorReporter> error_reporter);
            void bind(DocPtr document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitTraitImpl(const TraitImplPtr& trait_impl) override;

            std::shared_ptr<ErrorReporter> m_error_reporter;
            ModelDeclPtr m_current_model;
     };
}
