/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxSensor/RaytraceSystemNode.h>

#include <agx/Frame.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( LidarFrameNode );

  /**
  Lidar rays to world transform node.
  */
  class AGXSENSOR_EXPORT LidarFrameNode : public RtSystemNode
  {
    public:
      /**
      Construct given frame. A new frame will be created if \p frame is nullptr.
      \param frame - lidar rays frame
      */
      LidarFrameNode( agx::Frame* frame );

      /**
      \return the frame of the rays
      */
      agx::Frame* getFrame() const;

      /**
      Assign new frame of the lidar rays.
      \param frame - new frame of the lidar rays
      */
      void setFrame( agx::Frame* frame );

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual ~LidarFrameNode() = default;
      virtual RtNode* createNode() override;
      virtual void synchronize( const SystemNode::CallbackData& data ) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::LidarFrameNode );

    protected:
      LidarFrameNode();

    private:
      RtNode* updateTransform();

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::FrameRef m_frame;
  };
}
