/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/IMUModelSensorAttachment.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( IMUModel );

  /**
  IMU model describing which sensors are attached on this certain kind of IMU.
  \note The configuration in this model are shared and synchronized across all instances.
  */
  class AGXSENSOR_EXPORT IMUModel : public agx::Referenced, public agxStream::Serializable
  {
    public:
      /**
      Creates a 6 degrees of freedom IMU model (accelerometer, gyroscope) outputting ideal
      measurement data (ground truth values).
      \return new ideal 6 DoF IMU model
      */
      static IMUModel* makeIdealSixDoFModel();

      /**
      Creates a 9 degrees of freedom IMU model (accelerometer, gyroscope, magnetometer) outputting
      ideal measurement data (ground truth values).
      \return new ideal 9 DoF IMU model
      */
      static IMUModel* makeIdealNineDoFModel();

    public:
      /**
      Construct an IMU model with the given \p sensorAttachments.
      \param sensorAttachments - vector of attachments describing which sensor models are attached
                                 onto the IMU model
      */
      IMUModel( IMUModelSensorAttachmentRefVector sensorAttachments = IMUModelSensorAttachmentRefVector() );

      /**
      \return the vector describing which sensor models are attached onto the IMU model
      */
      const IMUModelSensorAttachmentRefVector& getSensorAttachments() const;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::IMUModel );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      IMUModelSensorAttachmentRefVector m_sensorAttachments;
  };
}
