%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D(prefix)
%rename(prefix ## StructuralComponent) openplx::Physics3D::StructuralComponent;
%rename(prefix ## StructuralPlane) openplx::Physics3D::StructuralPlane;
%rename(prefix ## System) openplx::Physics3D::System;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D()
%shared_ptr(openplx::Physics3D::StructuralComponent);
%shared_ptr(openplx::Physics3D::StructuralPlane);
%shared_ptr(openplx::Physics3D::System);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D()
%typemap(out) std::shared_ptr<openplx::Physics3D::StructuralComponent> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::StructuralPlane> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::System> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D()
%template(Physics3D_StructuralComponent_Vector) std::vector<std::shared_ptr<openplx::Physics3D::StructuralComponent>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::StructuralComponent>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::StructuralComponent>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::StructuralComponent>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::StructuralComponent>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::StructuralComponent>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::StructuralComponent>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_StructuralPlane_Vector) std::vector<std::shared_ptr<openplx::Physics3D::StructuralPlane>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::StructuralPlane>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::StructuralPlane>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::StructuralPlane>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::StructuralPlane>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::StructuralPlane>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::StructuralPlane>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_System_Vector) std::vector<std::shared_ptr<openplx::Physics3D::System>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::System>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::System>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D()
%include "openplx/Physics3D/System.h"
%include "openplx/Physics3D/StructuralComponent.h"
%include "openplx/Physics3D/StructuralPlane.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D()
%pythoncode %{
from . import Bodies
from . import Geometries
from . import Interactions
from . import Signals
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Bodies()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Bodies()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Bodies(prefix)
%rename(prefix ## Body) openplx::Physics3D::Bodies::Body;
%rename(prefix ## Inertia) openplx::Physics3D::Bodies::Inertia;
%rename(prefix ## Kinematics) openplx::Physics3D::Bodies::Kinematics;
%rename(prefix ## RigidBody) openplx::Physics3D::Bodies::RigidBody;
%rename(prefix ## RigidBodyKinematics) openplx::Physics3D::Bodies::RigidBodyKinematics;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Bodies()
%shared_ptr(openplx::Physics3D::Bodies::Body);
%shared_ptr(openplx::Physics3D::Bodies::Inertia);
%shared_ptr(openplx::Physics3D::Bodies::Kinematics);
%shared_ptr(openplx::Physics3D::Bodies::RigidBody);
%shared_ptr(openplx::Physics3D::Bodies::RigidBodyKinematics);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Bodies()
%typemap(out) std::shared_ptr<openplx::Physics3D::Bodies::Body> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Bodies::Inertia> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Bodies::Kinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Bodies()
%template(Physics3D_Bodies_Body_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Body>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Body>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Body>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Bodies_Inertia_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Inertia>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Inertia>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Inertia>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Bodies_Kinematics_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Bodies_RigidBody_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::RigidBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Bodies_RigidBodyKinematics_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Bodies::RigidBodyKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Bodies()
%include "openplx/Physics3D/Bodies/Body.h"
%include "openplx/Physics3D/Bodies/Inertia.h"
%include "openplx/Physics3D/Bodies/Kinematics.h"
%include "openplx/Physics3D/Bodies/RigidBody.h"
%include "openplx/Physics3D/Bodies/RigidBodyKinematics.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Bodies()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Geometries()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Geometries()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Geometries(prefix)
%rename(prefix ## Box) openplx::Physics3D::Geometries::Box;
%rename(prefix ## Capsule) openplx::Physics3D::Geometries::Capsule;
%rename(prefix ## ContactGeometry) openplx::Physics3D::Geometries::ContactGeometry;
%rename(prefix ## ConvexMesh) openplx::Physics3D::Geometries::ConvexMesh;
%rename(prefix ## Cylinder) openplx::Physics3D::Geometries::Cylinder;
%rename(prefix ## ExternalTriMeshGeometry) openplx::Physics3D::Geometries::ExternalTriMeshGeometry;
%rename(prefix ## Sphere) openplx::Physics3D::Geometries::Sphere;
%rename(prefix ## TriMesh) openplx::Physics3D::Geometries::TriMesh;
%rename(prefix ## TriMeshGeometry) openplx::Physics3D::Geometries::TriMeshGeometry;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Geometries()
%shared_ptr(openplx::Physics3D::Geometries::Box);
%shared_ptr(openplx::Physics3D::Geometries::Capsule);
%shared_ptr(openplx::Physics3D::Geometries::ContactGeometry);
%shared_ptr(openplx::Physics3D::Geometries::ConvexMesh);
%shared_ptr(openplx::Physics3D::Geometries::Cylinder);
%shared_ptr(openplx::Physics3D::Geometries::ExternalTriMeshGeometry);
%shared_ptr(openplx::Physics3D::Geometries::Sphere);
%shared_ptr(openplx::Physics3D::Geometries::TriMesh);
%shared_ptr(openplx::Physics3D::Geometries::TriMeshGeometry);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Geometries()
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::Box> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::Capsule> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::Sphere> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::TriMesh> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Geometries()
%template(Physics3D_Geometries_Box_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Box>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Box>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Box>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Box>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Box>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Box>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Box>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_Capsule_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Capsule>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Capsule>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Capsule>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Capsule>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Capsule>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Capsule>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Capsule>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_ContactGeometry_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ContactGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_ConvexMesh_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ConvexMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_Cylinder_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_ExternalTriMeshGeometry_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_Sphere_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Sphere>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Sphere>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Sphere>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Sphere>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::Sphere>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::Sphere>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::Sphere>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_TriMesh_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::TriMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Geometries_TriMeshGeometry_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Geometries::TriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Geometries()
%include "openplx/Physics3D/Geometries/ContactGeometry.h"
%include "openplx/Physics3D/Geometries/Box.h"
%include "openplx/Physics3D/Geometries/Capsule.h"
%include "openplx/Physics3D/Geometries/TriMeshGeometry.h"
%include "openplx/Physics3D/Geometries/ConvexMesh.h"
%include "openplx/Physics3D/Geometries/Cylinder.h"
%include "openplx/Physics3D/Geometries/ExternalTriMeshGeometry.h"
%include "openplx/Physics3D/Geometries/Sphere.h"
%include "openplx/Physics3D/Geometries/TriMesh.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Geometries()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions(prefix)
%rename(prefix ## AdaptiveMateConnector) openplx::Physics3D::Interactions::AdaptiveMateConnector;
%rename(prefix ## Ball) openplx::Physics3D::Interactions::Ball;
%rename(prefix ## Cylindrical) openplx::Physics3D::Interactions::Cylindrical;
%rename(prefix ## Distance) openplx::Physics3D::Interactions::Distance;
%rename(prefix ## ForceMotor) openplx::Physics3D::Interactions::ForceMotor;
%rename(prefix ## Hinge) openplx::Physics3D::Interactions::Hinge;
%rename(prefix ## LinearRange) openplx::Physics3D::Interactions::LinearRange;
%rename(prefix ## LinearSpring) openplx::Physics3D::Interactions::LinearSpring;
%rename(prefix ## LinearVelocityMotor) openplx::Physics3D::Interactions::LinearVelocityMotor;
%rename(prefix ## Lock) openplx::Physics3D::Interactions::Lock;
%rename(prefix ## Mate) openplx::Physics3D::Interactions::Mate;
%rename(prefix ## MateConnector) openplx::Physics3D::Interactions::MateConnector;
%rename(prefix ## Prismatic) openplx::Physics3D::Interactions::Prismatic;
%rename(prefix ## RangeInteraction1DOF) openplx::Physics3D::Interactions::RangeInteraction1DOF;
%rename(prefix ## RedirectedMateConnector) openplx::Physics3D::Interactions::RedirectedMateConnector;
%rename(prefix ## RotationalRange) openplx::Physics3D::Interactions::RotationalRange;
%rename(prefix ## RotationalVelocityMotor) openplx::Physics3D::Interactions::RotationalVelocityMotor;
%rename(prefix ## SpringInteraction1DOF) openplx::Physics3D::Interactions::SpringInteraction1DOF;
%rename(prefix ## StructuralPlanarConnector) openplx::Physics3D::Interactions::StructuralPlanarConnector;
%rename(prefix ## TorqueMotor) openplx::Physics3D::Interactions::TorqueMotor;
%rename(prefix ## TorsionSpring) openplx::Physics3D::Interactions::TorsionSpring;
%rename(prefix ## VelocityMotor) openplx::Physics3D::Interactions::VelocityMotor;
%rename(prefix ## World) openplx::Physics3D::Interactions::World;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions()
%shared_ptr(openplx::Physics3D::Interactions::AdaptiveMateConnector);
%shared_ptr(openplx::Physics3D::Interactions::Ball);
%shared_ptr(openplx::Physics3D::Interactions::Cylindrical);
%shared_ptr(openplx::Physics3D::Interactions::Distance);
%shared_ptr(openplx::Physics3D::Interactions::ForceMotor);
%shared_ptr(openplx::Physics3D::Interactions::Hinge);
%shared_ptr(openplx::Physics3D::Interactions::LinearRange);
%shared_ptr(openplx::Physics3D::Interactions::LinearSpring);
%shared_ptr(openplx::Physics3D::Interactions::LinearVelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::Lock);
%shared_ptr(openplx::Physics3D::Interactions::Mate);
%shared_ptr(openplx::Physics3D::Interactions::MateConnector);
%shared_ptr(openplx::Physics3D::Interactions::Prismatic);
%shared_ptr(openplx::Physics3D::Interactions::RangeInteraction1DOF);
%shared_ptr(openplx::Physics3D::Interactions::RedirectedMateConnector);
%shared_ptr(openplx::Physics3D::Interactions::RotationalRange);
%shared_ptr(openplx::Physics3D::Interactions::RotationalVelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::SpringInteraction1DOF);
%shared_ptr(openplx::Physics3D::Interactions::StructuralPlanarConnector);
%shared_ptr(openplx::Physics3D::Interactions::TorqueMotor);
%shared_ptr(openplx::Physics3D::Interactions::TorsionSpring);
%shared_ptr(openplx::Physics3D::Interactions::VelocityMotor);
%shared_ptr(openplx::Physics3D::Interactions::World);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Ball> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Distance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Hinge> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::LinearRange> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Lock> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Mate> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Prismatic> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::World> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions()
%template(Physics3D_Interactions_AdaptiveMateConnector_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::AdaptiveMateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Ball_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Ball>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Ball>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Ball>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Ball>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Ball>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Ball>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Ball>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Cylindrical_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Cylindrical>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Distance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Distance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Distance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Distance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Distance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Distance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_ForceMotor_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::ForceMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Hinge_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Hinge>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Hinge>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Hinge>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Hinge>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Hinge>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_LinearRange_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_LinearSpring_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearSpring>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_LinearVelocityMotor_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::LinearVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Lock_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Lock>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Lock>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Lock>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Lock>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Lock>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Lock>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Lock>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Mate_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Mate>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Mate>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Mate>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_MateConnector_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::MateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Prismatic_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Prismatic>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_RangeInteraction1DOF_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RangeInteraction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_RedirectedMateConnector_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RedirectedMateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_RotationalRange_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RotationalRange>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_RotationalVelocityMotor_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::RotationalVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_SpringInteraction1DOF_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SpringInteraction1DOF>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_StructuralPlanarConnector_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::StructuralPlanarConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_TorqueMotor_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::TorqueMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_TorsionSpring_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::TorsionSpring>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_VelocityMotor_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::VelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_World_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::World>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::World>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::World>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::World>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::World>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::World>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::World>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions()
%include "openplx/Physics3D/Interactions/MateConnector.h"
%include "openplx/Physics3D/Interactions/AdaptiveMateConnector.h"
%include "openplx/Physics3D/Interactions/Mate.h"
%include "openplx/Physics3D/Interactions/Ball.h"
%include "openplx/Physics3D/Interactions/Cylindrical.h"
%include "openplx/Physics3D/Interactions/Distance.h"
%include "openplx/Physics3D/Interactions/ForceMotor.h"
%include "openplx/Physics3D/Interactions/Hinge.h"
%include "openplx/Physics3D/Interactions/RangeInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearRange.h"
%include "openplx/Physics3D/Interactions/SpringInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearSpring.h"
%include "openplx/Physics3D/Interactions/VelocityMotor.h"
%include "openplx/Physics3D/Interactions/LinearVelocityMotor.h"
%include "openplx/Physics3D/Interactions/Lock.h"
%include "openplx/Physics3D/Interactions/Prismatic.h"
%include "openplx/Physics3D/Interactions/RedirectedMateConnector.h"
%include "openplx/Physics3D/Interactions/RotationalRange.h"
%include "openplx/Physics3D/Interactions/RotationalVelocityMotor.h"
%include "openplx/Physics3D/Interactions/StructuralPlanarConnector.h"
%include "openplx/Physics3D/Interactions/TorqueMotor.h"
%include "openplx/Physics3D/Interactions/TorsionSpring.h"
%include "openplx/Physics3D/Interactions/World.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions()
%pythoncode %{
from . import Clearance
from . import Dissipation
from . import Flexibility
from . import SurfaceContact
from . import Toughness
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_Clearance()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_Clearance()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Clearance(prefix)
%rename(prefix ## ConstantBallClearance) openplx::Physics3D::Interactions::Clearance::ConstantBallClearance;
%rename(prefix ## ConstantCylindricalClearance) openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance;
%rename(prefix ## ConstantHingeClearance) openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance;
%rename(prefix ## ConstantLockClearance) openplx::Physics3D::Interactions::Clearance::ConstantLockClearance;
%rename(prefix ## ConstantPrismaticClearance) openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance;
%rename(prefix ## DefaultMateClearance) openplx::Physics3D::Interactions::Clearance::DefaultMateClearance;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Clearance()
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantBallClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantLockClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance);
%shared_ptr(openplx::Physics3D::Interactions::Clearance::DefaultMateClearance);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Clearance()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Clearance()
%template(Physics3D_Interactions_Clearance_ConstantBallClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantBallClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Clearance_ConstantCylindricalClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantCylindricalClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Clearance_ConstantHingeClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantHingeClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Clearance_ConstantLockClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantLockClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Clearance_ConstantPrismaticClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::ConstantPrismaticClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Clearance_DefaultMateClearance_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Clearance()
%include "openplx/Physics3D/Interactions/Clearance/DefaultMateClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantBallClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantCylindricalClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantHingeClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantLockClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantPrismaticClearance.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_Clearance()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_Dissipation()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_Dissipation()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Dissipation(prefix)
%rename(prefix ## BallMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping;
%rename(prefix ## CylindricalMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping;
%rename(prefix ## DefaultBallDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation;
%rename(prefix ## DefaultCylindricalDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation;
%rename(prefix ## DefaultDistanceDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation;
%rename(prefix ## DefaultHingeDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation;
%rename(prefix ## DefaultLockDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation;
%rename(prefix ## DefaultMateDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation;
%rename(prefix ## DefaultPrismaticDissipation) openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation;
%rename(prefix ## DistanceMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping;
%rename(prefix ## HingeMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping;
%rename(prefix ## LockMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping;
%rename(prefix ## PrismaticMechanicalDamping) openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Dissipation()
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping);
%shared_ptr(openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Dissipation()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Dissipation()
%template(Physics3D_Interactions_Dissipation_BallMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::BallMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_CylindricalMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::CylindricalMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultBallDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultCylindricalDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultCylindricalDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultDistanceDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultDistanceDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultHingeDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultHingeDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultLockDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultMateDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DefaultPrismaticDissipation_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultPrismaticDissipation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_DistanceMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DistanceMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_HingeMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::HingeMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_LockMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::LockMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Dissipation_PrismaticMechanicalDamping_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::PrismaticMechanicalDamping>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Dissipation()
%include "openplx/Physics3D/Interactions/Dissipation/DefaultMateDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultBallDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/BallMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultCylindricalDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/CylindricalMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultDistanceDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultHingeDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultLockDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultPrismaticDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DistanceMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/HingeMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/LockMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/PrismaticMechanicalDamping.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_Dissipation()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_Flexibility()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_Flexibility()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Flexibility(prefix)
%rename(prefix ## DefaultBallFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility;
%rename(prefix ## DefaultCylindricalFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility;
%rename(prefix ## DefaultDistanceFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility;
%rename(prefix ## DefaultHingeFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility;
%rename(prefix ## DefaultLockFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility;
%rename(prefix ## DefaultMateFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility;
%rename(prefix ## DefaultPrismaticFlexibility) openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility;
%rename(prefix ## LinearElasticBallFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility;
%rename(prefix ## LinearElasticCylindricalFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility;
%rename(prefix ## LinearElasticDistanceFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility;
%rename(prefix ## LinearElasticHingeFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility;
%rename(prefix ## LinearElasticLockFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility;
%rename(prefix ## LinearElasticPrismaticFlexibility) openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Flexibility()
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility);
%shared_ptr(openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Flexibility()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Flexibility()
%template(Physics3D_Interactions_Flexibility_DefaultBallFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultCylindricalFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultCylindricalFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultDistanceFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultDistanceFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultHingeFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultHingeFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultLockFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultMateFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_DefaultPrismaticFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultPrismaticFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticBallFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticBallFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticCylindricalFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticCylindricalFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticDistanceFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticDistanceFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticHingeFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticHingeFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticLockFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticLockFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Flexibility_LinearElasticPrismaticFlexibility_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::LinearElasticPrismaticFlexibility>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Flexibility()
%include "openplx/Physics3D/Interactions/Flexibility/DefaultMateFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultDistanceFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultPrismaticFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticDistanceFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticPrismaticFlexibility.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_Flexibility()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_SurfaceContact()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_SurfaceContact()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_SurfaceContact(prefix)
%rename(prefix ## PatchElasticityDryFrictionModel) openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel;
%rename(prefix ## PointwiseElasticityDryFrictionModel) openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_SurfaceContact()
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel);
%shared_ptr(openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_SurfaceContact()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_SurfaceContact()
%template(Physics3D_Interactions_SurfaceContact_PatchElasticityDryFrictionModel_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PatchElasticityDryFrictionModel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_SurfaceContact_PointwiseElasticityDryFrictionModel_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::SurfaceContact::PointwiseElasticityDryFrictionModel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_SurfaceContact()
%include "openplx/Physics3D/Interactions/SurfaceContact/PatchElasticityDryFrictionModel.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/PointwiseElasticityDryFrictionModel.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_SurfaceContact()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_SurfaceContact_Traits()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_SurfaceContact_Traits(prefix)
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_SurfaceContact_Traits()
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_SurfaceContact_Traits()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Interactions_Toughness()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Interactions_Toughness()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Toughness(prefix)
%rename(prefix ## BallThresholdFracture) openplx::Physics3D::Interactions::Toughness::BallThresholdFracture;
%rename(prefix ## CylindricalThresholdFracture) openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture;
%rename(prefix ## DefaultBallToughness) openplx::Physics3D::Interactions::Toughness::DefaultBallToughness;
%rename(prefix ## DefaultCylindricalToughness) openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness;
%rename(prefix ## DefaultDistanceThoughness) openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness;
%rename(prefix ## DefaultHingeToughness) openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness;
%rename(prefix ## DefaultLockToughness) openplx::Physics3D::Interactions::Toughness::DefaultLockToughness;
%rename(prefix ## DefaultMateToughness) openplx::Physics3D::Interactions::Toughness::DefaultMateToughness;
%rename(prefix ## DefaultPrismaticToughness) openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness;
%rename(prefix ## HingeThresholdFracture) openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture;
%rename(prefix ## LockThresholdFracture) openplx::Physics3D::Interactions::Toughness::LockThresholdFracture;
%rename(prefix ## PrismaticThresholdFracture) openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Toughness()
%shared_ptr(openplx::Physics3D::Interactions::Toughness::BallThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultBallToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultLockToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultMateToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::LockThresholdFracture);
%shared_ptr(openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Toughness()
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Toughness()
%template(Physics3D_Interactions_Toughness_BallThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::BallThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_CylindricalThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::CylindricalThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultBallToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultCylindricalToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultCylindricalToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultDistanceThoughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultDistanceThoughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultHingeToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultHingeToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultLockToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultMateToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_DefaultPrismaticToughness_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultPrismaticToughness>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_HingeThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::HingeThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_LockThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::LockThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Interactions_Toughness_PrismaticThresholdFracture_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Interactions::Toughness::PrismaticThresholdFracture>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Toughness()
%include "openplx/Physics3D/Interactions/Toughness/DefaultMateToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultBallToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/BallThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultCylindricalToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/CylindricalThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultDistanceThoughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultHingeToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultLockToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultPrismaticToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/HingeThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/LockThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/PrismaticThresholdFracture.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Interactions_Toughness()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Signals()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Signals()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Signals(prefix)
%rename(prefix ## AngularVelocity3DInput) openplx::Physics3D::Signals::AngularVelocity3DInput;
%rename(prefix ## AngularVelocity3DOutput) openplx::Physics3D::Signals::AngularVelocity3DOutput;
%rename(prefix ## Force3DOutput) openplx::Physics3D::Signals::Force3DOutput;
%rename(prefix ## LinearVelocity3DInput) openplx::Physics3D::Signals::LinearVelocity3DInput;
%rename(prefix ## LinearVelocity3DOutput) openplx::Physics3D::Signals::LinearVelocity3DOutput;
%rename(prefix ## Position3DOutput) openplx::Physics3D::Signals::Position3DOutput;
%rename(prefix ## RPYOutput) openplx::Physics3D::Signals::RPYOutput;
%rename(prefix ## Torque3DInput) openplx::Physics3D::Signals::Torque3DInput;
%rename(prefix ## Torque3DOutput) openplx::Physics3D::Signals::Torque3DOutput;
%rename(prefix ## Vec3Marshalling) openplx::Physics3D::Signals::Vec3Marshalling;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Signals()
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DInput);
%shared_ptr(openplx::Physics3D::Signals::AngularVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Force3DOutput);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DInput);
%shared_ptr(openplx::Physics3D::Signals::LinearVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Position3DOutput);
%shared_ptr(openplx::Physics3D::Signals::RPYOutput);
%shared_ptr(openplx::Physics3D::Signals::Torque3DInput);
%shared_ptr(openplx::Physics3D::Signals::Torque3DOutput);
%shared_ptr(openplx::Physics3D::Signals::Vec3Marshalling);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Signals()
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::RPYOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Signals()
%template(Physics3D_Signals_AngularVelocity3DInput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_AngularVelocity3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::AngularVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_Force3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_LinearVelocity3DInput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_LinearVelocity3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_Position3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Position3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_RPYOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::RPYOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_Torque3DInput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Torque3DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_Torque3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Torque3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_Vec3Marshalling_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::Vec3Marshalling>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Signals()
%include "openplx/Physics3D/Signals/AngularVelocity3DInput.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/Force3DOutput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DInput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/Position3DOutput.h"
%include "openplx/Physics3D/Signals/RPYOutput.h"
%include "openplx/Physics3D/Signals/Torque3DInput.h"
%include "openplx/Physics3D/Signals/Torque3DOutput.h"
%include "openplx/Physics3D/Signals/Vec3Marshalling.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Signals()
%pythoncode %{
from . import MateConnector
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics3D_Signals_MateConnector()
%import "Physics3D_Signals.i"
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics3D_Signals_MateConnector()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics3D_Signals_MateConnector(prefix)
%rename(prefix ## Acceleration3DOutput) openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput;
%rename(prefix ## AngularAcceleration3DOutput) openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput;
%rename(prefix ## AngularVelocity3DOutput) openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput;
%rename(prefix ## LinearVelocity3DOutput) openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput;
%rename(prefix ## Output) openplx::Physics3D::Signals::MateConnector::Output;
%rename(prefix ## PositionOutput) openplx::Physics3D::Signals::MateConnector::PositionOutput;
%rename(prefix ## RPYOutput) openplx::Physics3D::Signals::MateConnector::RPYOutput;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Signals_MateConnector()
%shared_ptr(openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::Output);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::PositionOutput);
%shared_ptr(openplx::Physics3D::Signals::MateConnector::RPYOutput);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Signals_MateConnector()
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics3D_Signals_MateConnector()
%template(Physics3D_Signals_MateConnector_Acceleration3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Acceleration3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_AngularAcceleration3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularAcceleration3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_AngularVelocity3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::AngularVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_LinearVelocity3DOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::LinearVelocity3DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_Output_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::Output>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_PositionOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::PositionOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics3D_Signals_MateConnector_RPYOutput_Vector) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics3D::Signals::MateConnector::RPYOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics3D_Signals_MateConnector()
%include "openplx/Physics3D/Signals/MateConnector/Output.h"
%include "openplx/Physics3D/Signals/MateConnector/Acceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularAcceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/MateConnectorOutputTrait.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/PositionOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/RPYOutput.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics3D_Signals_MateConnector()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Physics3D()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D()
%import "Physics3D.i"
%import "Physics3D_Bodies.i"
%import "Physics3D_Geometries.i"
%import "Physics3D_Interactions.i"
%import "Physics3D_Interactions_Clearance.i"
%import "Physics3D_Interactions_Dissipation.i"
%import "Physics3D_Interactions_Flexibility.i"
%import "Physics3D_Interactions_SurfaceContact.i"
%import "Physics3D_Interactions_SurfaceContact_Traits.i"
%import "Physics3D_Interactions_Toughness.i"
%import "Physics3D_Signals.i"
%import "Physics3D_Signals_MateConnector.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Physics3D()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Physics3D()
%import "Math.i"
%import "Physics.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Physics3D(prefix)
OPENPLX_SWIG_NS_RENAMES_Physics3D(prefix);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Bodies(prefix ## Bodies_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Geometries(prefix ## Geometries_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions(prefix ## Interactions_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Clearance(prefix ## Interactions_Clearance_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Dissipation(prefix ## Interactions_Dissipation_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Flexibility(prefix ## Interactions_Flexibility_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_SurfaceContact(prefix ## Interactions_SurfaceContact_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_SurfaceContact_Traits(prefix ## Interactions_SurfaceContact_Traits_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Interactions_Toughness(prefix ## Interactions_Toughness_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Signals(prefix ## Signals_);
OPENPLX_SWIG_NS_RENAMES_Physics3D_Signals_MateConnector(prefix ## Signals_MateConnector_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics3D()
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Clearance();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Flexibility();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Interactions_Toughness();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Signals();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics3D_Signals_MateConnector();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics3D()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Clearance();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Dissipation();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Flexibility();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Interactions_Toughness();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Signals();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics3D_Signals_MateConnector();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Physics3D()
OPENPLX_SWIG_NS_VECTORS_Physics3D();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Bodies();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Geometries();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Clearance();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Dissipation();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Flexibility();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Interactions_Toughness();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Signals();
OPENPLX_SWIG_NS_VECTORS_Physics3D_Signals_MateConnector();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Physics3D()
OPENPLX_SWIG_NS_INCLUDES_Physics3D();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Bodies();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Geometries();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Clearance();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Dissipation();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Flexibility();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_SurfaceContact();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_SurfaceContact_Traits();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Interactions_Toughness();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Signals();
OPENPLX_SWIG_NS_INCLUDES_Physics3D_Signals_MateConnector();
%enddef

