#pragma once

#include <string>
#include <vector>

namespace openplx::Internal
{
    std::vector<std::string> split(const char * text, char splitchar);
    std::vector<std::string> split(const std::string& s, const std::string& delimiter);
    std::string join(const std::vector<std::string>& strings, const std::string& separator, size_t offset=0);
    std::string ltrim(std::string s);
    std::string rtrim(std::string s);
    std::string trim(std::string s);
    std::string replace(const std::string& source, const std::string& from, const std::string& to);
}
