#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/Optics/RaySource.h>
#include <openplx/Math/Vec2.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model HorizontalSweepRaySource */
namespace openplx::Sensors::Optics {
    /**
     *     Ray source that creates rays in a circular or semi-circular pattern, sweeping through
     *     the entire pattern at the specified frequency.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT HorizontalSweepRaySource : public openplx::Sensors::Optics::RaySource {
        protected:
            double m_frequency;
            std::shared_ptr<openplx::Math::Vec2> m_horizontal_fov;
            std::shared_ptr<openplx::Math::Vec2> m_vertical_fov;
            int64_t m_horizontal_resolution;
            int64_t m_vertical_resolution;

        public:
            HorizontalSweepRaySource();
            virtual ~HorizontalSweepRaySource();
            double frequency() const;
            std::shared_ptr<openplx::Math::Vec2> horizontal_fov() const;
            std::shared_ptr<openplx::Math::Vec2> vertical_fov() const;
            int64_t horizontal_resolution() const;
            int64_t vertical_resolution() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
