#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Signals/OutputSignal.h>
#include <openplx/Physics/Signals/Output.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RobotOutputSignal */
namespace openplx::Robotics::Signals {
    /**
     * The output signal of a robot.
     * sensor_values are named sensor values
     *
     * angles, angular_velocities and torques are per joint in the order defined in RobotOutput
     * object_values are object values in the order defined in RobotOutput
     *     */
    class OPENPLX_Robotics_BUNDLE_EXPORT RobotOutputSignal : public openplx::Physics::Signals::OutputSignal {
        protected:
            std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>> m_sensor_values;
            std::vector<double> m_angles;
            std::vector<double> m_angular_velocities;
            std::vector<double> m_torques;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> m_object_values;

        public:
            RobotOutputSignal();
            virtual ~RobotOutputSignal();
            std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>> sensor_values() const;
            std::vector<double> angles() const;
            std::vector<double> angular_velocities() const;
            std::vector<double> torques() const;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> object_values() const;
            static std::shared_ptr<openplx::Robotics::Signals::RobotOutputSignal> create(std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>> source_angle_signals, std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>> source_angular_velocity_signals, std::vector<std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal>> source_torque_signals, std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> object_values, std::vector<std::shared_ptr<openplx::Robotics::Signals::SensorValues>> sensor_values, std::shared_ptr<openplx::Physics::Signals::Output> source);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
