#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/EndEffectors/SuctionCup.h>
#include <openplx/Physics3D/Geometries/ExternalTriMeshGeometry.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Robotics/EndEffectors/SuctionCupElastoDynamics.h>
#include <openplx/Robotics/EndEffectors/SixDofSuctionCupJoint.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model SixDofSuctionCup */
namespace openplx::Robotics::EndEffectors {
    /**
     * A flexible suction cup modeled with one RigidBody and six degrees of freedom
     * for modeling the elasto dynamics.
     * There are elasto dynamic parameters defined for both the collapsed and the resting state.
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT SixDofSuctionCup : public openplx::Robotics::EndEffectors::SuctionCup {
        protected:
            std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry> m_geometry;
            std::shared_ptr<openplx::Math::Vec3> m_local_geometry_axis;
            std::shared_ptr<openplx::Math::Vec3> m_holder_relative_position;
            std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics> m_collapsed_elasto_dynamics;
            std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics> m_resting_elasto_dynamics;
            std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint> m_collapsed_joint;
            std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint> m_resting_joint;

        public:
            SixDofSuctionCup();
            virtual ~SixDofSuctionCup();
            std::shared_ptr<openplx::Physics3D::Geometries::ExternalTriMeshGeometry> geometry() const;
            std::shared_ptr<openplx::Math::Vec3> local_geometry_axis() const;
            std::shared_ptr<openplx::Math::Vec3> holder_relative_position() const;
            std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics> collapsed_elasto_dynamics() const;
            std::shared_ptr<openplx::Robotics::EndEffectors::SuctionCupElastoDynamics> resting_elasto_dynamics() const;
            std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint> collapsed_joint() const;
            std::shared_ptr<openplx::Robotics::EndEffectors::SixDofSuctionCupJoint> resting_joint() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
