#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/Torque1DInputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/Torque1DInput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model TorqueMotor */
namespace openplx::Physics3D::Interactions {
    /**
     *     A torque-driven motor provides precise and accurate control of the applied torque.
     *     The motor will initially be configured to apply the default torque.
     *     */
    class OPENPLX_Physics3D_BUNDLE_EXPORT TorqueMotor : public openplx::Physics::Interactions::Interaction1DOF, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::Torque1DInputTrait {
        protected:
            double m_default_torque;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::Torque1DInput> m_torque_input;

        public:
            TorqueMotor();
            virtual ~TorqueMotor();
            double default_torque() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DInput> torque_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
