#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics3D/Signals/Force3DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultBallDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultBallFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultBallToughness.h>
#include <openplx/Physics3D/Signals/Force3DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Ball */
namespace openplx::Physics3D::Interactions {
    /** Interaction that constrain all 3 translational degrees of freedom between two bodies, or one body and the world.*/
    class OPENPLX_Physics3D_BUNDLE_EXPORT Ball : public openplx::Physics3D::Interactions::Mate, public openplx::Physics3D::Signals::Force3DOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> m_force_output;

        public:
            Ball();
            virtual ~Ball();
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultBallDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultBallFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultBallToughness> toughness() const;
            std::shared_ptr<openplx::Physics3D::Signals::Force3DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
