/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/export.h>
#include <agxSensor/MonoaxialSignalSystemNode.h>

#include <agxStream/Serializable.h>

#include <agx/Range.h>
#include <agx/Referenced.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( OdometerModel );

  /**
  Base odometer model describing the fundamental parameters, such as wheel radius, of wheel encoder
  based odometers.
  \note The configuration in this model is shared and synchronized across all instances.
  */
  class AGXSENSOR_EXPORT OdometerModel : public agx::Referenced, public agxStream::Serializable
  {
    public:
      /**
      Construct an odometer model with the specified parameters.
      \param wheelRadius - wheel radius assumed by the odometer for distance calculation
      \param outputModifiers - list of modifiers to apply to the output of the encoder
      */
      OdometerModel( agx::Real wheelRadius = 0.4,
                     IMonoaxialSignalSystemNodeRefVector outputModifiers =
                       IMonoaxialSignalSystemNodeRefVector() );

      /**
      Set the radius of the assumed wheel which the odometer uses to determine distance traveled.
      \param wheelRadius - wheel radius assumed by the odometer for distance calculation
      */
      void setWheelRadius( agx::Real wheelRadius );

      /**
      \return wheel radius assumed by the odometer for distance calculation
      */
      agx::Real getWheelRadius() const;

      /**
      \return the list of output modifiers to apply to the output
      */
      const IMonoaxialSignalSystemNodeRefVector& getOutputModifiers() const;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual ~OdometerModel() = default;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::OdometerModel );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::Real m_wheelRadius;
      IMonoaxialSignalSystemNodeRefVector m_outputModifiers;
  };
}
