/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/MonoaxialSignalNoiseNode.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( MonoaxialGaussianNoise );

  /**
  Applies a total Gaussian noise to the monoaxial signal based on a specified noise RMS.
  */
  class AGXSENSOR_EXPORT MonoaxialGaussianNoise : public IMonoaxialSignalNoiseNode
  {
    public:
      /**
      Construct this total Gaussian noise based on the given \p noiseRms.
      \param noiseRms - sensor noise RMS in (measurement unit) RMS
      \param seed - seed used to configure the pseudo-random perturbation generation
      */
      MonoaxialGaussianNoise( agx::Real noiseRms = 0.135,
                              agx::UInt32 seed = 198749u );

      /**
      Set the sensor noise RMS.
      \param noiseRms - Sensor noise RMS in (measurement unit) RMS
      */
      void setNoiseRms( agx::Real noiseRms );

      /**
      \return sensor noise RMS specification in (measurement unit) RMS
      */
      agx::Real getNoiseRms() const;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual void result( SystemNodeProxy& proxy, const CallbackData& data ) override;
      virtual void cleanup( SystemNodeProxy& proxy ) override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::MonoaxialGaussianNoise );

      DOXYGEN_END_INTERNAL_BLOCK()

    private:
      agx::Real m_noiseRms;
  };
}
