/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/export.h>

#include <agxStream/Serializable.h>

#include <agx/Referenced.h>
#include <agx/Vec3.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( MagneticField );

  /**
  Base type for the specification of the magnetic field in a sensor environment. It supplies a
  function to calculate the magnetic field at arbitrary points in space, in world coordinates.
  */
  class AGXSENSOR_EXPORT MagneticField : public agx::Referenced, public agxStream::Serializable
  {
    public:
      /**
      Default constructor.
      */
      MagneticField() = default;

      /**
      Calculates and returns the magnetic field at the given \p position in world coordinates.
      \param position - position in world coordinates at which the magnetic field should be
                        determined
      \return magnetic field vector at the \p position
      */
      virtual agx::Vec3 calculateMagneticField( const agx::Vec3& position ) const = 0;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      AGXSTREAM_DECLARE_ABSTRACT_SERIALIZABLE( agxSensor::MagneticField );

    protected:
      virtual ~MagneticField() = default;

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
