#pragma once

#include <agxOSG/GuiEventListener.h>
#include <agxOSG/ExampleApplication.h>
#include <agxOSG/openplx/OsgClickInputListener.h>
#include <agxOSG/openplx/OsgClickAdapter.h>

namespace agxopenplx {
    class OsgClickAdapter;
    class AGXOSG_EXPORT ClickKeyboardEventListener : public agxSDK::GuiEventListener
    {
    public:
        ClickKeyboardEventListener(std::shared_ptr<ClickInputListener> click_input_listener, agxOSG::ExampleApplication *app, OsgClickAdapter *click_adapter);
        virtual bool keyboard(int key, unsigned modkeyMask, float x, float y, bool keyDown) override;
        /**
         * @brief Prefer this prio when adding this listener to an AGX Simulation
         *
         * Must have higher prio than ExampleApplication:s GuiEventListener to guarantee that signals are sent correctly
         *
         */
        static constexpr int RECOMMENDED_PRIO = agxSDK::EventManager::ExecutePriority::HIGHEST_PRIORITY - 1;

    private:
        std::shared_ptr<agxopenplx::ClickInputListener> m_click_input_listener;
        agxopenplx::OsgClickAdapter* m_click_adapter;
        agx::observer_ptr<agxOSG::ExampleApplication > m_app;
    };
}
