/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <agxModel/export.h>
#include <agx/String.h>

namespace agxDriveTrain {

  struct CombustionEngineParameters;

  /**
  Class with methods to read and write CombustionEngineParameters to and from JSON files or JSON formatted strings.
  */
  class AGXMODEL_EXPORT CombustionEngineParametersReaderWriter
  {
    public:

      /**
      Read parameters from a CombustionEngineParameters object and write result to a string in JSON format.
      \param parameters - The CombustionEngineParameters whose values should be read
      \param jsonOutput - String in json format that will contain the output
      \return True if json output could be written to the string
      */
      static bool writeJsonString( const agxDriveTrain::CombustionEngineParameters* parameters, agx::String& jsonOutput );

      /**
      Read parameters from CombustionEngineParameters and write result to a CombustionEngineParameters definition file
      in JSON format.
      \param parameters - The CombustionEngineParameters whose values should be read
      \param filename - Name of file where JSON data should be written
      \return True if file could successfully be written
      */
      static bool writeJson( const agxDriveTrain::CombustionEngineParameters* parameters, const agx::String& filename );

      /**
      Read parameters from a string with JSON data and assign values to a CombustionEngineParameters object.
      \param parameters - The CombustionEngineParameters object to be updated
      \param jsonContents - String with JSON data
      \return True if JSON data could be read and assigned to the CombustionEngineParameters
      */
      static bool readJsonString(agxDriveTrain::CombustionEngineParameters* parameters, const agx::String& jsonContents );

      /**
      Read parameters from a file with json format and assign values to a CombustionEngineParameters object.
      \param parameters - The CombustionEngineParameters to modify
      \param filename - Name of input file
      \return True if json data could be read and assigned to the CombustionEngineParameters
      */
      static bool readJson(agxDriveTrain::CombustionEngineParameters* parameters, const agx::String& filename );
  };
}

