/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#ifndef AGX_SYSTEMINFORMATION_H
#define AGX_SYSTEMINFORMATION_H

#include <agx/agx.h>
#include <agx/Integer.h>

namespace agx
{
  class AGXCORE_EXPORT SystemInformation
  {
  public:
    /**
    \return CPU frequency in MHz
    */
    static agx::UInt getCpuFrequency();

    /**
    \return the number of processing units
    */
    static agx::UInt getNumCpu();

    /**
    Retrieve a text description about the hardware being used.
    Which information that is presented depends on the operating system used
    and the information should at least contain CPU name and amount of RAM memory.

    \return Textual description of computer hardware.
    */
    static const char* getHardwareSpecification();

  };
}


#endif /* _AGX_SYSTEMINFORMATION_H_ */
