%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Visuals_Geometries()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Visuals_Geometries()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Visuals/Visuals_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Visuals_Geometries(prefix)
%rename(prefix ## Box) openplx::Visuals::Geometries::Box;
%rename(prefix ## ConvexMesh) openplx::Visuals::Geometries::ConvexMesh;
%rename(prefix ## Cylinder) openplx::Visuals::Geometries::Cylinder;
%rename(prefix ## ExternalTriMeshGeometry) openplx::Visuals::Geometries::ExternalTriMeshGeometry;
%rename(prefix ## Geometry) openplx::Visuals::Geometries::Geometry;
%rename(prefix ## Sphere) openplx::Visuals::Geometries::Sphere;
%rename(prefix ## TriMeshGeometry) openplx::Visuals::Geometries::TriMeshGeometry;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Visuals_Geometries()
%shared_ptr(openplx::Visuals::Geometries::Box);
%shared_ptr(openplx::Visuals::Geometries::ConvexMesh);
%shared_ptr(openplx::Visuals::Geometries::Cylinder);
%shared_ptr(openplx::Visuals::Geometries::ExternalTriMeshGeometry);
%shared_ptr(openplx::Visuals::Geometries::Geometry);
%shared_ptr(openplx::Visuals::Geometries::Sphere);
%shared_ptr(openplx::Visuals::Geometries::TriMeshGeometry);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Visuals_Geometries()
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::Box> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::Cylinder> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::Geometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::Sphere> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Visuals_Geometries()
%template(Visuals_Geometries_Box_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Box>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::Box>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::Box>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Box>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Box>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::Box>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Box>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_ConvexMesh_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::ConvexMesh>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_Cylinder_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Cylinder>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::Cylinder>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Cylinder>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::Cylinder>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Cylinder>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_ExternalTriMeshGeometry_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::ExternalTriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_Geometry_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Geometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::Geometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::Geometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Geometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Geometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::Geometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Geometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_Sphere_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Sphere>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::Sphere>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::Sphere>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Sphere>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::Sphere>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::Sphere>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::Sphere>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Geometries_TriMeshGeometry_Vector) std::vector<std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Geometries::TriMeshGeometry>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Visuals_Geometries()
%include "openplx/Visuals/Geometries/Geometry.h"
%include "openplx/Visuals/Geometries/Box.h"
%include "openplx/Visuals/Geometries/TriMeshGeometry.h"
%include "openplx/Visuals/Geometries/ConvexMesh.h"
%include "openplx/Visuals/Geometries/Cylinder.h"
%include "openplx/Visuals/Geometries/ExternalTriMeshGeometry.h"
%include "openplx/Visuals/Geometries/Sphere.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Visuals_Geometries()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Visuals_Materials()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Visuals_Materials()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Visuals/Visuals_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Visuals_Materials(prefix)
%rename(prefix ## Material) openplx::Visuals::Materials::Material;
%rename(prefix ## TextureMaterial) openplx::Visuals::Materials::TextureMaterial;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Visuals_Materials()
%shared_ptr(openplx::Visuals::Materials::Material);
%shared_ptr(openplx::Visuals::Materials::TextureMaterial);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Visuals_Materials()
%typemap(out) std::shared_ptr<openplx::Visuals::Materials::Material> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Visuals::Materials::TextureMaterial> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Visuals_Materials()
%template(Visuals_Materials_Material_Vector) std::vector<std::shared_ptr<openplx::Visuals::Materials::Material>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Materials::Material>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Materials::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Materials::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Materials::Material>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Materials::Material>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Materials::Material>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Visuals_Materials_TextureMaterial_Vector) std::vector<std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Visuals::Materials::TextureMaterial>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Visuals_Materials()
%include "openplx/Visuals/Materials/Material.h"
%include "openplx/Visuals/Materials/TextureMaterial.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Visuals_Materials()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Visuals()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Visuals/Visuals_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Visuals()
%import "Visuals_Geometries.i"
%import "Visuals_Materials.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Visuals()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Visuals()
%import "Math.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Visuals(prefix)
OPENPLX_SWIG_NS_RENAMES_Visuals_Geometries(prefix ## Geometries_);
OPENPLX_SWIG_NS_RENAMES_Visuals_Materials(prefix ## Materials_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Visuals()
OPENPLX_SWIG_NS_SHARED_POINTERS_Visuals_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTERS_Visuals_Materials();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Visuals()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Visuals_Geometries();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Visuals_Materials();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Visuals()
OPENPLX_SWIG_NS_VECTORS_Visuals_Geometries();
OPENPLX_SWIG_NS_VECTORS_Visuals_Materials();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Visuals()
OPENPLX_SWIG_NS_INCLUDES_Visuals_Geometries();
OPENPLX_SWIG_NS_INCLUDES_Visuals_Materials();
%enddef

