%module(package="openplx") Physics3D
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Physics3D(Physics3D_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics3D();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics3D();
OPENPLX_SWIG_BUNDLE_VECTORS_Physics3D();
%include "openplx/Physics3D/Bodies/Body.h"
%include "openplx/Physics3D/Bodies/Inertia.h"
%include "openplx/Physics3D/Bodies/Kinematics.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DInputTrait.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DInputTrait.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/Position3DOutputTrait.h"
%include "openplx/Physics3D/Signals/RPYOutputTrait.h"
%include "openplx/Physics3D/Bodies/RigidBody.h"
%include "openplx/Physics3D/Bodies/RigidBodyKinematics.h"
%include "openplx/Physics3D/Signals/MateConnector/MCLinearVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Signals/MateConnector/MCAngularVelocity3DOutputTrait.h"
%include "openplx/Physics3D/Charges/MateConnector.h"
%include "openplx/Physics3D/Charges/AdaptiveMateConnector.h"
%include "openplx/Physics3D/Charges/ContactGeometry.h"
%include "openplx/Physics3D/Charges/Box.h"
%include "openplx/Physics3D/Charges/Capsule.h"
%include "openplx/Physics3D/Charges/TriMeshGeometry.h"
%include "openplx/Physics3D/Charges/ConvexMesh.h"
%include "openplx/Physics3D/Charges/Cylinder.h"
%include "openplx/Physics3D/Charges/ExternalTriMeshGeometry.h"
%include "openplx/Physics3D/Charges/RedirectedMateConnector.h"
%include "openplx/Physics3D/Charges/Sphere.h"
%include "openplx/Physics3D/Charges/StructuralPlanarConnector.h"
%include "openplx/Physics3D/Charges/TriMesh.h"
%include "openplx/Physics3D/Charges/World.h"
%include "openplx/Physics3D/Interactions/Mate.h"
%include "openplx/Physics3D/Interactions/Ball.h"
%include "openplx/Physics3D/Interactions/Clearance/DefaultMateClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantBallClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantCylindricalClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantHingeClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantLockClearance.h"
%include "openplx/Physics3D/Interactions/Clearance/ConstantPrismaticClearance.h"
%include "openplx/Physics3D/Interactions/Cylindrical.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultMateDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultBallDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/BallMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultCylindricalDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/CylindricalMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultHingeDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultLockDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/DefaultPrismaticDissipation.h"
%include "openplx/Physics3D/Interactions/Dissipation/HingeMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/LockMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Dissipation/PrismaticMechanicalDamping.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultMateFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/DefaultPrismaticFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticBallFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticCylindricalFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticHingeFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticLockFlexibility.h"
%include "openplx/Physics3D/Interactions/Flexibility/LinearElasticPrismaticFlexibility.h"
%include "openplx/Physics3D/Interactions/ForceMotor.h"
%include "openplx/Physics3D/Interactions/Hinge.h"
%include "openplx/Physics3D/Interactions/RangeInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearRange.h"
%include "openplx/Physics3D/Interactions/SpringInteraction1DOF.h"
%include "openplx/Physics3D/Interactions/LinearSpring.h"
%include "openplx/Physics3D/Interactions/VelocityMotor.h"
%include "openplx/Physics3D/Interactions/LinearVelocityMotor.h"
%include "openplx/Physics3D/Interactions/Lock.h"
%include "openplx/Physics3D/Interactions/Prismatic.h"
%include "openplx/Physics3D/Interactions/RotationalRange.h"
%include "openplx/Physics3D/Interactions/RotationalVelocityMotor.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/PatchElasticityDryFrictionModel.h"
%include "openplx/Physics3D/Interactions/SurfaceContact/PointwiseElasticityDryFrictionModel.h"
%include "openplx/Physics3D/Interactions/TorqueMotor.h"
%include "openplx/Physics3D/Interactions/TorsionSpring.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultMateToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultBallToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/BallThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultCylindricalToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/CylindricalThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultHingeToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultLockToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/DefaultPrismaticToughness.h"
%include "openplx/Physics3D/Interactions/Toughness/HingeThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/LockThresholdFracture.h"
%include "openplx/Physics3D/Interactions/Toughness/PrismaticThresholdFracture.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DInput.h"
%include "openplx/Physics3D/Signals/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DInput.h"
%include "openplx/Physics3D/Signals/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/Output.h"
%include "openplx/Physics3D/Signals/MateConnector/Acceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularAcceleration3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/MateConnectorOutputTrait.h"
%include "openplx/Physics3D/Signals/MateConnector/AngularVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/LinearVelocity3DOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/PositionOutput.h"
%include "openplx/Physics3D/Signals/MateConnector/RPYOutput.h"
%include "openplx/Physics3D/Signals/Position3DOutput.h"
%include "openplx/Physics3D/Signals/RPYOutput.h"
%include "openplx/Physics3D/Signals/Torque3DInput.h"
%include "openplx/Physics3D/Signals/Torque3DOutput.h"
%include "openplx/Physics3D/System.h"
%include "openplx/Physics3D/StructuralComponent.h"
%include "openplx/Physics3D/StructuralPlane.h"
