%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics1D_Bodies()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics1D_Bodies()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics1D_Bodies(prefix)
%rename(prefix ## Body) openplx::Physics1D::Bodies::Body;
%rename(prefix ## Inertia) openplx::Physics1D::Bodies::Inertia;
%rename(prefix ## Kinematics) openplx::Physics1D::Bodies::Kinematics;
%rename(prefix ## LinearBody) openplx::Physics1D::Bodies::LinearBody;
%rename(prefix ## LinearKinematics) openplx::Physics1D::Bodies::LinearKinematics;
%rename(prefix ## RotationalBody) openplx::Physics1D::Bodies::RotationalBody;
%rename(prefix ## RotationalKinematics) openplx::Physics1D::Bodies::RotationalKinematics;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Bodies()
%shared_ptr(openplx::Physics1D::Bodies::Body);
%shared_ptr(openplx::Physics1D::Bodies::Inertia);
%shared_ptr(openplx::Physics1D::Bodies::Kinematics);
%shared_ptr(openplx::Physics1D::Bodies::LinearBody);
%shared_ptr(openplx::Physics1D::Bodies::LinearKinematics);
%shared_ptr(openplx::Physics1D::Bodies::RotationalBody);
%shared_ptr(openplx::Physics1D::Bodies::RotationalKinematics);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Bodies()
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::Body> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::Inertia> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::Kinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::LinearBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics1D_Bodies()
%template(Physics1D_Bodies_Body_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Body>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Body>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Body>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Body>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Body>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_Inertia_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Inertia>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Inertia>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Inertia>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Inertia>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Inertia>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_Kinematics_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::Kinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_LinearBody_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::LinearBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_LinearKinematics_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::LinearKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_RotationalBody_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::RotationalBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Bodies_RotationalKinematics_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Bodies::RotationalKinematics>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics1D_Bodies()
%include "openplx/Physics1D/Bodies/Body.h"
%include "openplx/Physics1D/Bodies/Inertia.h"
%include "openplx/Physics1D/Bodies/Kinematics.h"
%include "openplx/Physics1D/Bodies/LinearBody.h"
%include "openplx/Physics1D/Bodies/LinearKinematics.h"
%include "openplx/Physics1D/Bodies/RotationalBody.h"
%include "openplx/Physics1D/Bodies/RotationalKinematics.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics1D_Bodies()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics1D_Charges()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics1D_Charges()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics1D_Charges(prefix)
%rename(prefix ## LinearConnector) openplx::Physics1D::Charges::LinearConnector;
%rename(prefix ## MateConnector) openplx::Physics1D::Charges::MateConnector;
%rename(prefix ## RotationalConnector) openplx::Physics1D::Charges::RotationalConnector;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Charges()
%shared_ptr(openplx::Physics1D::Charges::LinearConnector);
%shared_ptr(openplx::Physics1D::Charges::MateConnector);
%shared_ptr(openplx::Physics1D::Charges::RotationalConnector);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Charges()
%typemap(out) std::shared_ptr<openplx::Physics1D::Charges::LinearConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Charges::MateConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics1D_Charges()
%template(Physics1D_Charges_LinearConnector_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::LinearConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Charges_MateConnector_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Charges::MateConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Charges::MateConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Charges::MateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::MateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Charges::MateConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Charges::MateConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::MateConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Charges_RotationalConnector_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Charges::RotationalConnector>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics1D_Charges()
%include "openplx/Physics1D/Charges/MateConnector.h"
%include "openplx/Physics1D/Charges/LinearConnector.h"
%include "openplx/Physics1D/Charges/RotationalConnector.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics1D_Charges()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Physics1D_Interactions()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Physics1D_Interactions()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Physics1D_Interactions(prefix)
%rename(prefix ## Mate) openplx::Physics1D::Interactions::Mate;
%rename(prefix ## RotationalVelocityMotor) openplx::Physics1D::Interactions::RotationalVelocityMotor;
%rename(prefix ## VelocityMotor) openplx::Physics1D::Interactions::VelocityMotor;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Interactions()
%shared_ptr(openplx::Physics1D::Interactions::Mate);
%shared_ptr(openplx::Physics1D::Interactions::RotationalVelocityMotor);
%shared_ptr(openplx::Physics1D::Interactions::VelocityMotor);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Interactions()
%typemap(out) std::shared_ptr<openplx::Physics1D::Interactions::Mate> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Physics1D_Interactions()
%template(Physics1D_Interactions_Mate_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::Mate>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Interactions::Mate>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::Mate>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Interactions::Mate>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::Mate>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Interactions_RotationalVelocityMotor_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::RotationalVelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Physics1D_Interactions_VelocityMotor_Vector) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Physics1D::Interactions::VelocityMotor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Physics1D_Interactions()
%include "openplx/Physics1D/Interactions/Mate.h"
%include "openplx/Physics1D/Interactions/VelocityMotor.h"
%include "openplx/Physics1D/Interactions/RotationalVelocityMotor.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Physics1D_Interactions()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Physics1D()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D()
%import "Physics1D_Bodies.i"
%import "Physics1D_Charges.i"
%import "Physics1D_Interactions.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Physics1D()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Physics1D()
%import "Math.i"
%import "Physics.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Physics1D(prefix)
OPENPLX_SWIG_NS_RENAMES_Physics1D_Bodies(prefix ## Bodies_);
OPENPLX_SWIG_NS_RENAMES_Physics1D_Charges(prefix ## Charges_);
OPENPLX_SWIG_NS_RENAMES_Physics1D_Interactions(prefix ## Interactions_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics1D()
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Charges();
OPENPLX_SWIG_NS_SHARED_POINTERS_Physics1D_Interactions();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics1D()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Bodies();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Charges();
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Physics1D_Interactions();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Physics1D()
OPENPLX_SWIG_NS_VECTORS_Physics1D_Bodies();
OPENPLX_SWIG_NS_VECTORS_Physics1D_Charges();
OPENPLX_SWIG_NS_VECTORS_Physics1D_Interactions();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Physics1D()
OPENPLX_SWIG_NS_INCLUDES_Physics1D_Bodies();
OPENPLX_SWIG_NS_INCLUDES_Physics1D_Charges();
OPENPLX_SWIG_NS_INCLUDES_Physics1D_Interactions();
%enddef

