#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/CyclicVariation.h>
/* Generated code for model SinusoidalVariation */
namespace openplx::Vehicles::Tracks {
    /**
     * A variation of a pattern, where the amplitude will
     * will increase with a sinusiodal variation.
     * The additional_amplitude is the amplitude of the function,
     * and the period is the wavelength of the function.
     **/
    class SinusoidalVariation : public openplx::Vehicles::Tracks::CyclicVariation {
        protected:
            double m_additional_amplitude;
            double m_period;

        public:
            SinusoidalVariation();
            double additional_amplitude() const;
            double period() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
