#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/DefaultLinkDescription.h>
/* Generated code for model Belt */
namespace openplx::Vehicles::Tracks {
    /**
     * Defines the geometrical properties of a Tracks Belt.
     * The length is the distance between each connection between links,
     * independent of the contact geometry defined for by the link_description.
     **/
    class Belt : public openplx::Core::Object {
        protected:
            std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription> m_link_description;

        public:
            Belt();
            std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription> link_description() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
