#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Robotics/Joints/HingeJointData.h>
/* Generated code for model FlexibleJointData */
namespace openplx::Robotics::Joints {
    class FlexibleJointData : public openplx::Robotics::Joints::HingeJointData {
        protected:
            double m_motor_damping;
            double m_motor_inertia;
            double m_motor_stiffness;
            double m_gear_inertia;
            double m_gear_ratio;
            double m_max_motor_torque;

        public:
            FlexibleJointData();
            double motor_damping() const;
            double motor_inertia() const;
            double motor_stiffness() const;
            double gear_inertia() const;
            double gear_ratio() const;
            double max_motor_torque() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
