#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>
/* Generated code for model VelocityMotor */
namespace openplx::Physics3D::Interactions {
    /**
     *     A velocity-driven motor provides precise and accurate control of speed and position.
     *     The gain of a velocity-driven motor can be defined as the ratio of the change in motor speed to
     *     the change in control input signal. It determines how responsive the motor output is to changes
     *     in the input signal, thus influencing the motor's performance. Generally, higher gain motors are
     *     faster and more responsive to changes in control signals, while lower gain motors are more stable but slower to act.
     *     The motor will always try to keep the specifed target_speed.
     *     If the zero_speed_as_spring is enabled, the motor will act as a spring when the target_speed is set to zero,
     *     with the gain value as the default elastic stiffness.
     *
     *     charges are typically set to the charges of the Mate that the motor complement.
     *     */
    class VelocityMotor : public openplx::Physics::Interactions::Interaction1DOF {
        protected:
            double m_gain;
            double m_target_speed;
            bool m_zero_speed_as_spring;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> m_zero_speed_spring_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_zero_speed_spring_dissipation;

        public:
            VelocityMotor();
            double gain() const;
            double target_speed() const;
            bool zero_speed_as_spring() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::LinearElastic> zero_speed_spring_flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> zero_speed_spring_dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
