#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h>
/* Generated code for model DryConstantNormalForceFriction */
namespace openplx::Physics::Interactions::Dissipation {
    /**
     *     The DryConstantNormalForceFriction extends the DefaultDryFriction model
     *     by introducing a constant normal force for friction computation.
     *     The friction limit f_L is always going to be:
     *     f_L = normal_force * coefficient.
     *     The model must be considered VERY approximative, since it does not consider friction as
     *     a non-linear problem.
     *     */
    class DryConstantNormalForceFriction : public openplx::Physics::Interactions::Dissipation::DefaultDryFriction {
        protected:
            double m_normal_force;

        public:
            DryConstantNormalForceFriction();
            double normal_force() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
