
#pragma once

#include <openplx/NodeType.h>

namespace openplx
{
    class NodeVisitor
    {
        public:
            virtual void visitDocument(const DocPtr& document);
            virtual void visitModelDeclaration(const ModelDeclPtr& model_declaration);
            virtual void visitVarDeclaration(const VarDeclPtr& var_declaration);
            virtual void visitVarAssignment(const VarAssignPtr& var_assignment);
            virtual void visitMethodDeclaration(const MethodDeclPtr& method_declaration);
            virtual void visitConstant(const ConstantPtr& constant);
            virtual void visitCall(const CallPtr& call);
            virtual void visitMemberAccess(const MemberAccessPtr& member_access);
            virtual void visitArray(const ArrayPtr& array);
            virtual void visitUnary(const UnaryPtr& unary);
            virtual void visitBinaryOp(const BinaryOpPtr& binary_op);
            virtual void visitPrimitiveType(const PrimitiveTypePtr& primitive_type);
            virtual void visitArrayType(const ArrayTypePtr& array_type);
            virtual void visitParameter(const ParamPtr& parameter);
            virtual void visitIndexing(const IndexingPtr& indexing);
            virtual void visitOperatorOverload(const OpOverloadPtr& op_overload);
            virtual void visitAnnotation(const AnnotationPtr& annotation);
            virtual void visitImport(const ImportPtr& import);
            virtual void visitTraitImpl(const TraitImplPtr& trait_impl);
            virtual void visitInitializer(const InitializerPtr& initializer);
            virtual void visitInitializerType(const InitializerTypePtr& initializer_type);
            virtual void visitDeletion(const DeletionPtr& del);
            virtual void visitWithType(const WithTypePtr& with_type);
            virtual void visitSymbolMetaData(const SymbolMetaDataPtr& symbol_meta_data);

            virtual ~NodeVisitor() = default;
    };
}
