#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathForward.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model Quat */
namespace openplx::Math {
    class Quat : public openplx::Core::Object {
        protected:
            double m_x;
            double m_y;
            double m_z;
            double m_w;

        public:
            Quat();
            double x() const;
            double y() const;
            double z() const;
            double w() const;
            std::shared_ptr<openplx::Math::Vec3> rotate(std::shared_ptr<openplx::Math::Vec3> v) const;
            std::shared_ptr<openplx::Math::Quat> conj() const;
            std::shared_ptr<openplx::Math::Quat> inverse() const;
            static std::shared_ptr<openplx::Math::Quat> angle_axis(double angle, std::shared_ptr<openplx::Math::Vec3> axis);
            static std::shared_ptr<openplx::Math::Quat> from_to(std::shared_ptr<openplx::Math::Vec3> from, std::shared_ptr<openplx::Math::Vec3> to);
            static std::shared_ptr<openplx::Math::Quat> normal(std::shared_ptr<openplx::Math::Quat> q);
            static std::shared_ptr<openplx::Math::Quat> from_xyzw(double x, double y, double z, double w);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xyzs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xyxs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xzys(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xzxs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yzxs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yzys(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yxzs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yxys(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zxys(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zxzs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zyxs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zyzs(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zyxr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xyxr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yzxr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xzxr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xzyr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yzyr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zxyr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yxyr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_yxzr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zxzr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_xyzr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles_zyzr(double alpha, double beta, double gamma);
            static std::shared_ptr<openplx::Math::Quat> from_euler_angles(double alpha, double beta, double gamma);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
