#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
/* Generated code for model VelocityRatioTorqueMultiplicationPair */
namespace openplx::DriveTrain {
    /**
     *     The velocity_ratio is found from the turbine velocity divided by the pump velocity.
     *     The torque converter is modeled from measured values of torque multiplication given velocity_ratio.
     *     */
    class VelocityRatioTorqueMultiplicationPair : public openplx::Core::Object {
        protected:
            double m_velocity_ratio;
            double m_multiplier;

        public:
            VelocityRatioTorqueMultiplicationPair();
            double velocity_ratio() const;
            double multiplier() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
