#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics/Interactions/Interaction1DOF.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/FractionInputTrait.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/FractionInput.h>
/* Generated code for model CombustionEngine */
namespace openplx::DriveTrain {
    /**
     *   'displacement_volume' represents the engine's total displacement volume, essentially, the combined volumes of all its cylinders.
     *   'max_torque' indicates the maximum brake torque that the engine can supply, either for brief or sustained periods.
     *   'max_torque_RPM' is the crankshaft rotation speed at which the maximum allowable torque is produced.
     *   'max_power_RPM' is the rotational speed of the crankshaft when the engine is delivering its maximum rated power.
     *   'idle_RPM' refers to the speed of the idle crankshaft; it's the speed at which the engine runs when it's not working.
     *   'crank_shaft_inertia' is the internal inertia of the engine
     *   The default values are chosen from Figure 1-11, Pulkabek2004, Engineering fundamentals of the internal combustion engine.
     *   The initial_throttle is a value between 0-1, where 0 is no throttle, and 1 is max throttle.
     *
     *   */
    class CombustionEngine : public openplx::Physics::Interactions::Interaction1DOF, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::FractionInputTrait {
        protected:
            double m_displacement_volume;
            double m_max_torque;
            double m_max_torque_RPM;
            double m_max_power_RPM;
            double m_idle_RPM;
            double m_crank_shaft_inertia;
            double m_initial_throttle;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> m_throttle_input;

        public:
            CombustionEngine();
            double displacement_volume() const;
            double max_torque() const;
            double max_torque_RPM() const;
            double max_power_RPM() const;
            double idle_RPM() const;
            double crank_shaft_inertia() const;
            double initial_throttle() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::FractionInput> throttle_input() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
