#pragma once

#include <memory>
#include <stdint.h>
#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>

namespace openplx {
    /**
     * Keeps track of which models has nested declarations in them, this is used to report errors
     * when trying to specialize a extended symbol, example:
     *
     * Foo:
     *     x is Real: 1.0
     *
     * Foo2 is Foo:
     *     y is Real: 2.0
     *
     * Bar:
     *     foo is Foo:
     *         z is Real: 3.0 # <- foo is tagged as `extended` in Bar due to this nested declaration
     *
     * Bar2 is Bar:
     *     foo becomes Foo2 # <- Invalid since foo is extended in Bar
     *
     */
    class BindExtendedSymbolsVisitor : private NodeVisitor {
        public:
            explicit BindExtendedSymbolsVisitor();
            void bind(const DocPtr& document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
    };
}
