#pragma once

//#include <sstream>
#include <math.h>
#include <agx/Vec3.h>
#ifndef vec3i
struct vec3i { int x, y, z; };
#endif

//#define __USE_SSE__
#include "mathlib/vector.h"
#include "mathlib/matrix.h"

struct vec3d
{
  double x, y, z;

  inline vec3d(void) :x(0), y(0), z(0) {}

  //inline vec3d operator =( vector3 a )
  // { vec3d b ; b.x = a.x; b.y = a.y; b.z = a.z; return b;}

  inline vec3d(vector3 a)
  {
    x = a.x; y = a.y; z = a.z;
  }

  inline vec3d(const agx::Vec3& a)
  {
    x = a[0]; y = a[1]; z = a[2];
  }

  inline vec3d(const double X, const double Y, const double Z)
  {
    x = X; y = Y; z = Z;
  }

  inline vec3d operator + (const vec3d& a) const
  {
    return vec3d(x + a.x, y + a.y, z + a.z);
  }

  inline vec3d operator += (const vec3d& a)
  {
    x += a.x;
    y += a.y;
    z += a.z;

    return *this;
  }

  inline vec3d operator * (const double a) const
  {
    return vec3d(x * a, y * a, z * a);
  }

  inline vec3d operator * (const vec3d a) const
  {
    return vec3d(x * a.x, y * a.y, z * a.z);
  }

  inline vector3 v3() const
  {
    return vector3((float)x, (float)y, (float)z);
  }

  inline vec3d operator = (const vector3 a)
  {
    x = a.x; y = a.y; z = a.z; return *this;
  }

  inline vec3d operator = (const vec3d a)
  {
    x = a.x; y = a.y; z = a.z; return *this;
  }

  inline vec3d operator / (const vec3d a) const
  {
    return vec3d(x / a.x, y / a.y, z / a.z);
  }

  inline vec3d operator - (const vec3d& a) const
  {
    return vec3d(x - a.x, y - a.y, z - a.z);
  }

  inline vec3d operator / (const double a) const
  {
    return vec3d(x / a, y / a, z / a);
  }

  inline double dot(const vec3d& a) const
  {
    return a.x * x + a.y * y + a.z * z;
  }

  inline vec3d cross(const vec3d& a, const vec3d& b)
  {
    x = a.y * b.z - a.z * b.y;
    y = a.z * b.x - a.x * b.z;
    z = a.x * b.y - a.y * b.x;
    return *this;
  }

  inline double angle(const vec3d& v)
  {
    vec3d a = v, b = *this;
    double dot = v.x * x + v.y * y + v.z * z;
    double len = a.length() * b.length();
    if (len == 0)len = 0.00001f;
    double input = dot / len;
    if (input < -1) input = -1;
    if (input > 1) input = 1;
    return (double)acos(input);
  }

  inline double angle2(const vec3d& v, const vec3d& w)
  {
    vec3d a = v, b = *this;
    double dot = a.x * b.x + a.y * b.y + a.z * b.z;
    double len = a.length() * b.length();
    if (len == 0)len = 1;

    vec3d plane; plane.cross(b, w);

    if (plane.x * a.x + plane.y * a.y + plane.z * a.z > 0)
      return (double)-acos(dot / len);

    return (double)acos(dot / len);
  }

  inline vec3d rot_x(double a)
  {
    double yy = cos(a) * y + sin(a) * z;
    double zz = cos(a) * z - sin(a) * y;
    y = yy; z = zz;
    return *this;
  }
  inline vec3d rot_y(double a)
  {
    double xx = cos(-a) * x + sin(-a) * z;
    double zz = cos(-a) * z - sin(-a) * x;
    x = xx; z = zz;
    return *this;
  }
  inline void clamp(double min, double max)
  {
    if (x < min) x = min;
    if (y < min) y = min;
    if (z < min) z = min;
    if (x > max) x = max;
    if (y > max) y = max;
    if (z > max) z = max;
  }
  inline vec3d rot_z(double a)
  {
    double yy = cos(a) * y + sin(a) * x;
    double xx = cos(a) * x - sin(a) * y;
    y = yy; x = xx;
    return *this;
  }
  inline vec3d invert()
  {
    x = -x; y = -y; z = -z; return *this;
  }
  inline vec3d frac()
  {
    return vec3d(
      x - double(int(x)),
      y - double(int(y)),
      z - double(int(z))
    );
  }

  inline vec3d integer()
  {
    return vec3d(
      double(int(x)),
      double(int(y)),
      double(int(z))
    );
  }

  inline double length() const
  {
    return (double)sqrt(x * x + y * y + z * z);
  }

  inline vec3d normalize()
  {
    double square = sqrt(x * x + y * y + z * z);

    x /= square; y /= square; z /= square;

    return *this;
  }
  static vec3d normalize(vec3d a);

  static void random_init();
  static double random_double();
  static vec3d random();

  static int random_number;

  double random_double_01(double a) {
    double rnf = a * 14.434252 + a * 364.2343 + a * 4213.45352 + a * 2341.43255 + a * 254341.43535 + a * 223454341.3523534245 + 23453.423412;
    int rni = ((int)rnf) % 100000;
    return double(rni) / (100000.0f - 1.0f);
  }

  vec3d random01_fxyz() {
    x = (double)random_double_01(x);
    y = (double)random_double_01(y);
    z = (double)random_double_01(z);
    return *this;
  }
};
