%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Simulation/Simulation_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Simulation::CollisionGroup;
%nspace openplx::Simulation::DisableCollisionPair;
%nspace openplx::Simulation::Environment;
%nspace openplx::Simulation::GravitationalField;
%nspace openplx::Simulation::PointGravitationalField;
%nspace openplx::Simulation::UniformGravitationalField;
%shared_ptr(openplx::Simulation::CollisionGroup);
%shared_ptr(openplx::Simulation::DisableCollisionPair);
%shared_ptr(openplx::Simulation::Environment);
%shared_ptr(openplx::Simulation::GravitationalField);
%shared_ptr(openplx::Simulation::PointGravitationalField);
%shared_ptr(openplx::Simulation::UniformGravitationalField);
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::CollisionGroup)
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::DisableCollisionPair)
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::Environment)
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::GravitationalField)
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::PointGravitationalField)
OPENPLX_FIX_DOWNCASTING(openplx::Simulation::UniformGravitationalField)
%include "openplx/Simulation/CollisionGroup.h"
%include "openplx/Simulation/DisableCollisionPair.h"
%include "openplx/Simulation/Environment.h"
%include "openplx/Simulation/GravitationalField.h"
%include "openplx/Simulation/PointGravitationalField.h"
%include "openplx/Simulation/UniformGravitationalField.h"
%ignore Simulation_register_factories;
%include <openplx/Simulation/Simulation_all.h>
%inline {
    void Simulation_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Simulation_register_factories(eval_ctx);
    }
}
%template(SimulationCollisionGroupVector) std::vector<std::shared_ptr<openplx::Simulation::CollisionGroup>>;
%template(SimulationDisableCollisionPairVector) std::vector<std::shared_ptr<openplx::Simulation::DisableCollisionPair>>;
%template(SimulationEnvironmentVector) std::vector<std::shared_ptr<openplx::Simulation::Environment>>;
%template(SimulationGravitationalFieldVector) std::vector<std::shared_ptr<openplx::Simulation::GravitationalField>>;
%template(SimulationPointGravitationalFieldVector) std::vector<std::shared_ptr<openplx::Simulation::PointGravitationalField>>;
%template(SimulationUniformGravitationalFieldVector) std::vector<std::shared_ptr<openplx::Simulation::UniformGravitationalField>>;
