%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/OpenPlxContext.h>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/Math/Math_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%nspace openplx::Math::AffineTransform;
%nspace openplx::Math::Functions;
%nspace openplx::Math::Line;
%nspace openplx::Math::Matrix3x3;
%nspace openplx::Math::Matrix4x4;
%nspace openplx::Math::Quat;
%nspace openplx::Math::Vec2;
%nspace openplx::Math::Vec3;
%shared_ptr(openplx::Math::AffineTransform);
%shared_ptr(openplx::Math::Functions);
%shared_ptr(openplx::Math::Line);
%shared_ptr(openplx::Math::Matrix3x3);
%shared_ptr(openplx::Math::Matrix4x4);
%shared_ptr(openplx::Math::Quat);
%shared_ptr(openplx::Math::Vec2);
%shared_ptr(openplx::Math::Vec3);
OPENPLX_FIX_DOWNCASTING(openplx::Math::AffineTransform)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Functions)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Line)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Matrix3x3)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Matrix4x4)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Quat)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Vec2)
OPENPLX_FIX_DOWNCASTING(openplx::Math::Vec3)
%include "openplx/Math/AffineTransform.h"
%include "openplx/Math/Functions.h"
%include "openplx/Math/Line.h"
%include "openplx/Math/Matrix3x3.h"
%include "openplx/Math/Matrix4x4.h"
%include "openplx/Math/Quat.h"
%include "openplx/Math/Vec2.h"
%include "openplx/Math/Vec3.h"
%ignore Math_register_factories;
%include <openplx/Math/Math_all.h>
%inline {
    void Math_register_factories_cs(openplx::Core::Api::OpenPlxContext* ctx) {
        auto internal_ctx = openplx::Core::Api::OpenPlxContextInternal::fromContext(*ctx);
        auto eval_ctx = internal_ctx->evaluatorContext().get();
        Math_register_factories(eval_ctx);
    }
}
%template(MathAffineTransformVector) std::vector<std::shared_ptr<openplx::Math::AffineTransform>>;
%template(MathFunctionsVector) std::vector<std::shared_ptr<openplx::Math::Functions>>;
%template(MathLineVector) std::vector<std::shared_ptr<openplx::Math::Line>>;
%template(MathMatrix3x3Vector) std::vector<std::shared_ptr<openplx::Math::Matrix3x3>>;
%template(MathMatrix4x4Vector) std::vector<std::shared_ptr<openplx::Math::Matrix4x4>>;
%template(MathQuatVector) std::vector<std::shared_ptr<openplx::Math::Quat>>;
%template(MathVec2Vector) std::vector<std::shared_ptr<openplx::Math::Vec2>>;
%template(MathVec3Vector) std::vector<std::shared_ptr<openplx::Math::Vec3>>;
%ignore operator *(const std::shared_ptr<openplx::Math::AffineTransform>& p_0, const std::shared_ptr<openplx::Math::AffineTransform>& p_1);
%ignore operator +(const std::shared_ptr<openplx::Math::Matrix3x3>& p_0, const std::shared_ptr<openplx::Math::Matrix3x3>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Matrix3x3>& p_0, const std::shared_ptr<openplx::Math::Matrix3x3>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Matrix3x3>& p_0, const std::shared_ptr<openplx::Math::Matrix3x3>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Matrix3x3>& p_0, const std::shared_ptr<openplx::Math::Vec3>& p_1);
%ignore operator +(const std::shared_ptr<openplx::Math::Matrix4x4>& p_0, const std::shared_ptr<openplx::Math::Matrix4x4>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Matrix4x4>& p_0, const std::shared_ptr<openplx::Math::Matrix4x4>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Matrix4x4>& p_0, const std::shared_ptr<openplx::Math::Matrix4x4>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Quat>& p_0, double p_1);
%ignore operator *(double p_0, const std::shared_ptr<openplx::Math::Quat>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Quat>& p_0, const std::shared_ptr<openplx::Math::Quat>& p_1);
%ignore operator /(const std::shared_ptr<openplx::Math::Quat>& p_0, double p_1);
%ignore operator /(const std::shared_ptr<openplx::Math::Quat>& p_0, const std::shared_ptr<openplx::Math::Quat>& p_1);
%ignore operator +(const std::shared_ptr<openplx::Math::Quat>& p_0, const std::shared_ptr<openplx::Math::Quat>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Quat>& p_0, const std::shared_ptr<openplx::Math::Quat>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Quat>& p_0);
%ignore operator +(const std::shared_ptr<openplx::Math::Vec2>& p_0, const std::shared_ptr<openplx::Math::Vec2>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Vec2>& p_0, const std::shared_ptr<openplx::Math::Vec2>& p_1);
%ignore operator *(double p_0, const std::shared_ptr<openplx::Math::Vec2>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Vec2>& p_0, double p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Vec2>& p_0, const std::shared_ptr<openplx::Math::Vec2>& p_1);
%ignore operator /(const std::shared_ptr<openplx::Math::Vec2>& p_0, double p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Vec2>& p_0);
%ignore operator +(const std::shared_ptr<openplx::Math::Vec3>& p_0, const std::shared_ptr<openplx::Math::Vec3>& p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Vec3>& p_0, const std::shared_ptr<openplx::Math::Vec3>& p_1);
%ignore operator *(double p_0, const std::shared_ptr<openplx::Math::Vec3>& p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Vec3>& p_0, double p_1);
%ignore operator *(const std::shared_ptr<openplx::Math::Vec3>& p_0, const std::shared_ptr<openplx::Math::Vec3>& p_1);
%ignore operator /(const std::shared_ptr<openplx::Math::Vec3>& p_0, double p_1);
%ignore operator -(const std::shared_ptr<openplx::Math::Vec3>& p_0);
%extend openplx::Math::AffineTransform {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::AffineTransform>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::AffineTransform>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::AffineTransform>) rhs) {
    var result_any = $module.operator_Star_Math_AffineTransform_Math_AffineTransform($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::AffineTransform>);
}
%}
}
%extend openplx::Math::Matrix3x3 {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) operator +($typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) rhs) {
    var result_any = $module.operator_Plus_Math_Matrix3x3_Math_Matrix3x3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) rhs) {
    var result_any = $module.operator_Minus_Math_Matrix3x3_Math_Matrix3x3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) rhs) {
    var result_any = $module.operator_Star_Math_Matrix3x3_Math_Matrix3x3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Matrix3x3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) rhs) {
    var result_any = $module.operator_Star_Math_Matrix3x3_Math_Vec3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
%}
}
%extend openplx::Math::Matrix4x4 {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) operator +($typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) rhs) {
    var result_any = $module.operator_Plus_Math_Matrix4x4_Math_Matrix4x4($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) rhs) {
    var result_any = $module.operator_Minus_Math_Matrix4x4_Math_Matrix4x4($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>) rhs) {
    var result_any = $module.operator_Star_Math_Matrix4x4_Math_Matrix4x4($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Matrix4x4>);
}
%}
}
%extend openplx::Math::Quat {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Star_Math_Quat_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator *($typemap(cstype,double) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) rhs) {
    var result_any = $module.operator_Star_Real_Math_Quat(new $typemap(cstype, openplx::Core::Any)(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) rhs) {
    var result_any = $module.operator_Star_Math_Quat_Math_Quat($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator /($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Slash_Math_Quat_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator /($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) rhs) {
    var result_any = $module.operator_Slash_Math_Quat_Math_Quat($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator +($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) rhs) {
    var result_any = $module.operator_Plus_Math_Quat_Math_Quat($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) rhs) {
    var result_any = $module.operator_Minus_Math_Quat_Math_Quat($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Quat>) operand) {
    var result_any = $module.operator_Minus_Math_Quat($typemap(cstype, openplx::Core::Any).fromObject(operand));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Quat>);
}
%}
}
%extend openplx::Math::Vec2 {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator +($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) rhs) {
    var result_any = $module.operator_Plus_Math_Vec2_Math_Vec2($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) rhs) {
    var result_any = $module.operator_Minus_Math_Vec2_Math_Vec2($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator *($typemap(cstype,double) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) rhs) {
    var result_any = $module.operator_Star_Real_Math_Vec2(new $typemap(cstype, openplx::Core::Any)(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Star_Math_Vec2_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
public static $typemap(cstype,double) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) rhs) {
    var result_any = $module.operator_Star_Math_Vec2_Math_Vec2($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asReal();}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator /($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Slash_Math_Vec2_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Vec2>) operand) {
    var result_any = $module.operator_Minus_Math_Vec2($typemap(cstype, openplx::Core::Any).fromObject(operand));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec2>);
}
%}
}
%extend openplx::Math::Vec3 {
%proxycode %{
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator +($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) rhs) {
    var result_any = $module.operator_Plus_Math_Vec3_Math_Vec3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) rhs) {
    var result_any = $module.operator_Minus_Math_Vec3_Math_Vec3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator *($typemap(cstype,double) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) rhs) {
    var result_any = $module.operator_Star_Real_Math_Vec3(new $typemap(cstype, openplx::Core::Any)(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Star_Math_Vec3_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
public static $typemap(cstype,double) operator *($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) lhs, $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) rhs) {
    var result_any = $module.operator_Star_Math_Vec3_Math_Vec3($typemap(cstype, openplx::Core::Any).fromObject(lhs), $typemap(cstype, openplx::Core::Any).fromObject(rhs));
    return result_any.asReal();}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator /($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) lhs, $typemap(cstype,double) rhs) {
    var result_any = $module.operator_Slash_Math_Vec3_Real($typemap(cstype, openplx::Core::Any).fromObject(lhs), new $typemap(cstype, openplx::Core::Any)(rhs));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
public static $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operator -($typemap(cstype,std::shared_ptr<openplx::Math::Vec3>) operand) {
    var result_any = $module.operator_Minus_Math_Vec3($typemap(cstype, openplx::Core::Any).fromObject(operand));
    return result_any.asObject() as $typemap(cstype,std::shared_ptr<openplx::Math::Vec3>);
}
%}
}
