/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/RaytraceInstanceData.h>

namespace agxSensor
{
  /**
  Raytrace shape instance data with a handle to the dito on the GPU,
  data and shape (ref-counting so that it's released when no instances
  uses the shape).
  */
  struct AGXSENSOR_EXPORT RtShapeInstance
  {
    /**
    Create given \p scene and \p shape.
    \param scene - scene to create the instance within
    \param shape - shape handle for the instance
    \param data - interface for data coupled to the (to be) created instance
    \return created shape instance in the sensor environment
    */
    static RtShapeInstance create( RtSceneRef scene, RtShapeRef shape, RtInstanceData* data );

    /**
    \return true if instance and mesh handles are valid
    */
    bool isValid() const;

    /**
    Set/update transform and/or scale of this shape instance in the raytrace
    environment.
    \param agxTransform - new transform
    \param scale - new mesh scale
    */
    void setTransform( const agx::AffineMatrix4x4& agxTransform,
                      agx::Vec3 scale = agx::Vec3( 1 ) );

    RtShapeInstanceHandleRef handle{ nullptr };
    RtInstanceDataObserver data{ nullptr };
    RtShapeHandleRef shape{ nullptr };
  };

  inline bool RtShapeInstance::isValid() const
  {
    return handle != nullptr &&
          shape != nullptr;
  }
}
