/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#define AGXSENSOR_POD_STRUCT( T, POD_T, POD_NAME )\
          struct T : POD_T { T( const POD_T& value ) : POD_T( value ) {}; using POD_T::POD_NAME; using POD_T::operator=; }

#define AGXSENSOR_SCALAR_STRUCT_T( N, T )\
          struct N : ::agxSensor::RtScalar<T>\
          {\
            using RtScalar::Scalar;\
            using RtScalar::operator=;\
            using RtScalar::operator==;\
          }

#define AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( N, T, DEFAULT )\
          struct N : ::agxSensor::RtScalar<T>\
          {\
            static constexpr T DefaultValue = T{ DEFAULT };\
            using RtScalar::RtScalar;\
            using RtScalar::operator=;\
            using RtScalar::operator==;\
          }

namespace agxSensor
{
  DOXYGEN_START_INTERNAL_BLOCK()

  template<typename T>
  struct RtScalar
  {
    using value_type = T;

    RtScalar() : value{}
    {
    }

    explicit RtScalar( T value )
      : value{ value }
    {
    }

    template<typename T2>
    RtScalar& operator=( T2 other )
    {
      this->value = (T)other;
      return *this;
    }

    template<typename T2>
    bool operator==( const T2& other ) const
    {
      return value == (T)other;
    }

    operator T() const
    {
      return value;
    }

    operator T& ( )
    {
      return value;
    }

    T value;
  };


  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtLambertianOpaqueReflectivity, float, 0.8f );

  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtGgxOrenNayanRefractiveIndexReal, float, 1.4517f ); // SiO2 @ 905 nm
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtGgxOrenNayanRefractiveIndexImaginary, float, 0.0f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtGgxOrenNayanBeckmanRoughness, float, 0.3f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtGgxOrenNayanOrenNayarRoughness, float, 0.3f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtGgxOrenNayanDiffuseReflectance, float, 0.8f );

  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtBrdfExplicitResolution, size_t, 1u );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtBrdfExplicitValue, float, RtLambertianOpaqueReflectivity::DefaultValue );

  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtAmbientRefractiveIndex, float, 1.000273f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtAmbientAttenuationCoefficient, float, 0.000402272f ); // Blickfeld fog @ V = 10 km
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtAmbientReturnProbabilityScaling, float, 1.58899e-05f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtAmbientReturnGammaDistributionShapeParameter, float, 9.5f );
  AGXSENSOR_SCALAR_STRUCT_T_DEFAULT( RtAmbientReturnGammaDistributionScaleParameter, float, 0.52f );

  DOXYGEN_END_INTERNAL_BLOCK()
}
