/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/FrameAttachedSensor.h>

namespace agxSensor
{
  AGX_DECLARE_POINTER_TYPES( IMUModelSensorAttachment );
  AGX_DECLARE_VECTOR_TYPES( IMUModelSensorAttachment );

  /**
  Specification of a sensor attachment onto the IMU.
  */
  struct IMUModelSensorAttachmentSensorAttachment
  {
    size_t outputId;                // Id from where the IMU should fetch the output.
    FrameAttachedSensorRef sensor;  // The sensor.
  };

  /**
  Base type for specifying sensor attachments onto an IMU model.
  */
  class AGXSENSOR_EXPORT IMUModelSensorAttachment : public agx::Referenced,
                                                    public agxStream::Serializable
  {
    public:
      using SensorAttachment = IMUModelSensorAttachmentSensorAttachment;
      using SensorAttachmentVector = agx::Vector<SensorAttachment>;

    public:
      /**
      Default constructor.
      */
      IMUModelSensorAttachment() = default;

      /**
      \return a new instance of the sensor placed in an attachment specification
      */
      virtual SensorAttachment instantiateSensor() const = 0;

      DOXYGEN_START_INTERNAL_BLOCK()

    public:
      virtual ~IMUModelSensorAttachment() = default;

      AGXSTREAM_DECLARE_ABSTRACT_SERIALIZABLE( agxSensor::IMUModelSensorAttachment );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
