/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <memory>
#include <vector>
#include <agxSDK/StepEventListener.h>
#include <agxSDK/EventManager.h>
#include <agxSDK/Assembly.h>
#include <openplx/Simulation/Simulation_all.h>
#include <click/Server.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOpenPLX/OutputSignalListener.h>

namespace agxopenplx {
    /**
     * @brief Propagates output openplx signals to Click Messages
     *
     */
    class AGXOPENPLX_EXPORT ClickOutputListener: public agxSDK::StepEventListener {

        public:
            ClickOutputListener(
                std::shared_ptr<click::Server>& server,
                std::shared_ptr<OutputSignalQueue> output_queue);

            void post(const agx::TimeStamp &prev_step) override;
            void last(const agx::TimeStamp &simulated_time) override;
            /**
             * @brief Prefer this prio when adding OutputSignalListener to an AGX Simulation
             *
             * Must run after OutputSignalListener to guarantee that output signals are present
             *
             */
            static constexpr int RECOMMENDED_PRIO = OutputSignalListener::RECOMMENDED_PRIO - 10;

            /**
             * @brief Sends a reset message to client next time - WILL CANCEL WHATEVER OTHER MESSAGE WAS GOING TO BE SENT
             */
            void sendResetMessage();

        private:
            std::string robot_name_from(const openplx::Robotics::Signals::RobotOutputSignal& robot_output_signal);
            std::shared_ptr<click::Server> m_server;
            std::shared_ptr<OutputSignalQueue> m_output_queue;
            bool m_send_reset_message = false;
    };
}
