/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

class GraphicsThrottler
{
public:
  /**
   * \brief Construct a new Graphics Throttler object
   * 
   * \param fps Target frames per second, if <= 0 no throttling will be done
   */
  GraphicsThrottler(double fps = 0.0f);

  /**
   * \brief Returns whether rendering should be done or not
   * 
   * \param wall_clock wallclock time in seconds
   * \param auto_reset whether to perform rendered() call automatically or not.
   * \param timestep the simulation timestep
   * \return true it's time to render
   * \return false when it's not time to render
   */
  bool shouldRenderGraphics(double wall_clock, double timestep, bool auto_reset = true);

  /**
   * \brief Reset timer to wall_clock. Next render will happen 1/fps s from wall_clock
   * 
   * \param wall_clock wallclock time in seconds
   */
  void rendered(double wall_clock);

  /**
   * \brief Set the target fps to a new value. Next render will happen 1/fpx s from wall_clock
   * 
   * \param fps target frames per second, if <= 0 no throttling will be done
   */
  void setTargetFPS(double fps);

  /**
   * \brief Get the target fps, if <= 0 no throttling is done
   */
  double getTargetFPS();

  /**
   * \brief Reset the last rendered time and start from scratch. Next frame will be rendered.
   */
  void reset();

private:
  double m_fps;
  double m_last_render_timestamp;
};
