%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Vehicles_Tracks()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Vehicles_Tracks()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix)
%rename(prefix ## Belt) openplx::Vehicles::Tracks::Belt;
%rename(prefix ## BoxLinkDescription) openplx::Vehicles::Tracks::BoxLinkDescription;
%rename(prefix ## BoxLinkVariation) openplx::Vehicles::Tracks::BoxLinkVariation;
%rename(prefix ## ContactGeometryLinkDescription) openplx::Vehicles::Tracks::ContactGeometryLinkDescription;
%rename(prefix ## CyclicVariation) openplx::Vehicles::Tracks::CyclicVariation;
%rename(prefix ## CylindricalIdler) openplx::Vehicles::Tracks::CylindricalIdler;
%rename(prefix ## CylindricalRoadWheel) openplx::Vehicles::Tracks::CylindricalRoadWheel;
%rename(prefix ## CylindricalRoller) openplx::Vehicles::Tracks::CylindricalRoller;
%rename(prefix ## CylindricalSprocket) openplx::Vehicles::Tracks::CylindricalSprocket;
%rename(prefix ## DefaultLinkDescription) openplx::Vehicles::Tracks::DefaultLinkDescription;
%rename(prefix ## DefaultLinkVariation) openplx::Vehicles::Tracks::DefaultLinkVariation;
%rename(prefix ## DiscretePulseVariation) openplx::Vehicles::Tracks::DiscretePulseVariation;
%rename(prefix ## FixedLinkCountBelt) openplx::Vehicles::Tracks::FixedLinkCountBelt;
%rename(prefix ## IntertialRoadWheel) openplx::Vehicles::Tracks::IntertialRoadWheel;
%rename(prefix ## RigidCylindricalIdler) openplx::Vehicles::Tracks::RigidCylindricalIdler;
%rename(prefix ## RigidCylindricalRoadWheelBody) openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody;
%rename(prefix ## RigidCylindricalRoller) openplx::Vehicles::Tracks::RigidCylindricalRoller;
%rename(prefix ## RigidCylindricalSprocket) openplx::Vehicles::Tracks::RigidCylindricalSprocket;
%rename(prefix ## RoadWheel) openplx::Vehicles::Tracks::RoadWheel;
%rename(prefix ## SinusoidalVariation) openplx::Vehicles::Tracks::SinusoidalVariation;
%rename(prefix ## System) openplx::Vehicles::Tracks::System;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks()
%shared_ptr(openplx::Vehicles::Tracks::Belt);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::BoxLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::ContactGeometryLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::CyclicVariation);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::CylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkDescription);
%shared_ptr(openplx::Vehicles::Tracks::DefaultLinkVariation);
%shared_ptr(openplx::Vehicles::Tracks::DiscretePulseVariation);
%shared_ptr(openplx::Vehicles::Tracks::FixedLinkCountBelt);
%shared_ptr(openplx::Vehicles::Tracks::IntertialRoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalIdler);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalRoller);
%shared_ptr(openplx::Vehicles::Tracks::RigidCylindricalSprocket);
%shared_ptr(openplx::Vehicles::Tracks::RoadWheel);
%shared_ptr(openplx::Vehicles::Tracks::SinusoidalVariation);
%shared_ptr(openplx::Vehicles::Tracks::System);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks()
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::Belt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Vehicles::Tracks::System> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks()
%template(Vehicles_Tracks_Belt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::Belt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::Belt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::Belt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_BoxLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::BoxLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_ContactGeometryLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::ContactGeometryLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CyclicVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CyclicVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_CylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::CylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkDescription_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkDescription>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DefaultLinkVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DefaultLinkVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_DiscretePulseVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::DiscretePulseVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_FixedLinkCountBelt_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::FixedLinkCountBelt>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_IntertialRoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::IntertialRoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalIdler_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalIdler>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoadWheelBody_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoadWheelBody>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalRoller_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalRoller>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RigidCylindricalSprocket_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RigidCylindricalSprocket>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_RoadWheel_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::RoadWheel>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_SinusoidalVariation_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::SinusoidalVariation>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Vehicles_Tracks_System_Vector) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Vehicles::Tracks::System>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Vehicles::Tracks::System>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Vehicles::Tracks::System>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks()
%include "openplx/Vehicles/Tracks/Belt.h"
%include "openplx/Vehicles/Tracks/DefaultLinkDescription.h"
%include "openplx/Vehicles/Tracks/ContactGeometryLinkDescription.h"
%include "openplx/Vehicles/Tracks/BoxLinkDescription.h"
%include "openplx/Vehicles/Tracks/DefaultLinkVariation.h"
%include "openplx/Vehicles/Tracks/BoxLinkVariation.h"
%include "openplx/Vehicles/Tracks/CyclicVariation.h"
%include "openplx/Vehicles/Tracks/RoadWheel.h"
%include "openplx/Vehicles/Tracks/IntertialRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalRoadWheel.h"
%include "openplx/Vehicles/Tracks/CylindricalIdler.h"
%include "openplx/Vehicles/Tracks/CylindricalRoller.h"
%include "openplx/Vehicles/Tracks/CylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/DiscretePulseVariation.h"
%include "openplx/Vehicles/Tracks/FixedLinkCountBelt.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalIdler.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoadWheelBody.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalRoller.h"
%include "openplx/Vehicles/Tracks/RigidCylindricalSprocket.h"
%include "openplx/Vehicles/Tracks/SinusoidalVariation.h"
%include "openplx/Vehicles/Tracks/System.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Vehicles_Tracks()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Vehicles()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Vehicles/Vehicles_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Vehicles()
%import "Vehicles_Tracks.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Vehicles()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Vehicles()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Vehicles(prefix)
OPENPLX_SWIG_NS_RENAMES_Vehicles_Tracks(prefix ## Tracks_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTERS_Vehicles_Tracks();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Vehicles()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Vehicles_Tracks();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Vehicles()
OPENPLX_SWIG_NS_VECTORS_Vehicles_Tracks();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Vehicles()
OPENPLX_SWIG_NS_INCLUDES_Vehicles_Tracks();
%enddef

