%module(package="openplx") Physics
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="Math") <python/Math/MathModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Physics(Physics_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Physics();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Physics();
OPENPLX_SWIG_BUNDLE_VECTORS_Physics();
%include "openplx/Physics/Bodies/Body.h"
%include "openplx/Physics/Bodies/Inertia.h"
%include "openplx/Physics/Bodies/Kinematics.h"
%include "openplx/Physics/Charges/Charge.h"
%include "openplx/Physics/Charges/ContactGeometry.h"
%include "openplx/Physics/Charges/Material.h"
%include "openplx/Physics/Charges/LinearElasticMaterial.h"
%include "openplx/Physics/Interactions/Adhesion/DefaultAdhesion.h"
%include "openplx/Physics/Interactions/Adhesion/ConstantForceAdhesion.h"
%include "openplx/Physics/Interactions/Clearance/DefaultClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantAngleClearance.h"
%include "openplx/Physics/Interactions/Clearance/ConstantDistanceClearance.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultDissipation.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultFriction.h"
%include "openplx/Physics/Interactions/Dissipation/AsymmetricLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantLimitFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstantViscousSurfaceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/ConstraintRelaxationTimeDamping.h"
%include "openplx/Physics/Interactions/Dissipation/DefaultDryFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConeFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryDepthScaledConstantNormalForceFriction.h"
%include "openplx/Physics/Interactions/Dissipation/DryScaleBoxFriction.h"
%include "openplx/Physics/Interactions/Dissipation/MechanicalDamping.h"
%include "openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h"
%include "openplx/Physics/Interactions/Flexibility/LinearElastic.h"
%include "openplx/Physics/Interactions/Flexibility/Rigid.h"
%include "openplx/Physics/Signals/BoolInputTrait.h"
%include "openplx/Physics/Signals/BoolOutputTrait.h"
%include "openplx/Physics/Interactions/Interaction.h"
%include "openplx/Physics/Interactions/Interaction1DOF.h"
%include "openplx/Physics/Interactions/SurfaceContact/Model.h"
%include "openplx/Physics/Interactions/SurfaceContact/PatchElasticity.h"
%include "openplx/Physics/Interactions/SurfaceContact/PointwiseElasticity.h"
%include "openplx/Physics/Interactions/Toughness/DefaultToughness.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdFracture.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlastic.h"
%include "openplx/Physics/Interactions/Toughness/ThresholdPlasticFracture.h"
%include "openplx/Physics/Interactions/Toughness/Unbreakable.h"
%include "openplx/Physics/KinematicLock.h"
%include "openplx/Physics/Signals/Value.h"
%include "openplx/Physics/Signals/Vec3Value.h"
%include "openplx/Physics/Signals/Acceleration3DValue.h"
%include "openplx/Physics/Signals/Input.h"
%include "openplx/Physics/Signals/BoolInput.h"
%include "openplx/Physics/Signals/ActivateInput.h"
%include "openplx/Physics/Signals/Output.h"
%include "openplx/Physics/Signals/BoolOutput.h"
%include "openplx/Physics/Signals/ActivatedOutput.h"
%include "openplx/Physics/Signals/AngleInput.h"
%include "openplx/Physics/Signals/AngleOutput.h"
%include "openplx/Physics/Signals/RealValue.h"
%include "openplx/Physics/Signals/AngleValue.h"
%include "openplx/Physics/Signals/AngularAcceleration3DValue.h"
%include "openplx/Physics/Signals/AngularVelocity1DInput.h"
%include "openplx/Physics/Signals/AngularVelocity1DOutput.h"
%include "openplx/Physics/Signals/AngularVelocity1DValue.h"
%include "openplx/Physics/Signals/AngularVelocity3DValue.h"
%include "openplx/Physics/Signals/InputSignal.h"
%include "openplx/Physics/Signals/BoolInputSignal.h"
%include "openplx/Physics/Signals/BoolValue.h"
%include "openplx/Physics/Signals/DistanceValue.h"
%include "openplx/Physics/Signals/DurationInput.h"
%include "openplx/Physics/Signals/DurationOutput.h"
%include "openplx/Physics/Signals/DurationValue.h"
%include "openplx/Physics/Signals/EnableInteractionInput.h"
%include "openplx/Physics/Signals/EngageInput.h"
%include "openplx/Physics/Signals/EngagedOutput.h"
%include "openplx/Physics/Signals/Force1DInput.h"
%include "openplx/Physics/Signals/Force1DOutput.h"
%include "openplx/Physics/Signals/Force1DValue.h"
%include "openplx/Physics/Signals/Force3DOutput.h"
%include "openplx/Physics/Signals/Force3DValue.h"
%include "openplx/Physics/Signals/ForceRangeInput.h"
%include "openplx/Physics/Signals/ForceRangeOutput.h"
%include "openplx/Physics/Signals/Vec2Value.h"
%include "openplx/Physics/Signals/ForceRangeValue.h"
%include "openplx/Physics/Signals/FractionInput.h"
%include "openplx/Physics/Signals/FractionOutput.h"
%include "openplx/Physics/Signals/FractionValue.h"
%include "openplx/Physics/Signals/InputOutputType.h"
%include "openplx/Physics/Signals/IntInput.h"
%include "openplx/Physics/Signals/IntInputSignal.h"
%include "openplx/Physics/Signals/IntOutput.h"
%include "openplx/Physics/Signals/IntValue.h"
%include "openplx/Physics/Signals/InteractionEnabledOutput.h"
%include "openplx/Physics/Signals/LinearVelocity1DInput.h"
%include "openplx/Physics/Signals/LinearVelocity1DOutput.h"
%include "openplx/Physics/Signals/OutputSignal.h"
%include "openplx/Physics/Signals/Position1DInput.h"
%include "openplx/Physics/Signals/Position1DOutput.h"
%include "openplx/Physics/Signals/Position3DValue.h"
%include "openplx/Physics/Signals/RPYvalue.h"
%include "openplx/Physics/Signals/RealInputSignal.h"
%include "openplx/Physics/Signals/RealRangeInputSignal.h"
%include "openplx/Physics/Signals/RelativeVelocity1DOutput.h"
%include "openplx/Physics/Signals/SignalInterface.h"
%include "openplx/Physics/Signals/Torque1DInput.h"
%include "openplx/Physics/Signals/Torque1DOutput.h"
%include "openplx/Physics/Signals/Torque1DValue.h"
%include "openplx/Physics/Signals/Torque3DOutput.h"
%include "openplx/Physics/Signals/Torque3DValue.h"
%include "openplx/Physics/Signals/TorqueRangeInput.h"
%include "openplx/Physics/Signals/TorqueRangeOutput.h"
%include "openplx/Physics/Signals/TorqueRangeValue.h"
%include "openplx/Physics/Signals/ValueOutputSignal.h"
%include "openplx/Physics/Signals/Vec3InputSignal.h"
%include "openplx/Physics/Signals/Velocity1DValue.h"
%include "openplx/Physics/Signals/Velocity3DValue.h"
%include "openplx/Physics/System.h"
