#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Vehicles/Tracks/CyclicVariation.h>
/* Generated code for model DiscretePulseVariation */
namespace openplx::Vehicles::Tracks {
    /**
     * A variation of a descrete pattern, where every N'th value will increase with the additional_amplitude.    
     **/
    class DiscretePulseVariation : public openplx::Vehicles::Tracks::CyclicVariation {
        protected:
            double m_additional_amplitude;
            int64_t m_discrete_period;

        public:
            DiscretePulseVariation();
            double additional_amplitude() const;
            int64_t discrete_period() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
