#pragma once

#include <openplx/NodeVisitor.h>
#include <openplx/ErrorReporter.h>

namespace openplx {
    /**
     * Validates all traits in a document
     */
    class ValidateTraitsVisitor : private NodeVisitor {
        public:
            ValidateTraitsVisitor(std::shared_ptr<ErrorReporter> error_reporter);
            void validate(const DocPtr& document);

        private:
            void visitDocument(const DocPtr& document) override;

            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;

            void checkCommonAncestor(const ModelDeclPtr& model_declaration, const TraitImplPtr& trait);
            bool hasCommonAncestor(const TraitImplPtr& a, const TraitImplPtr& b) const;

            std::shared_ptr<ErrorReporter> m_error_reporter;
    };
}
