
#pragma once

#include <memory>
#include <vector>
#include <openplx/ErrorReporter.h>
#include <openplx/ModelDeclaration.h>
#include <openplx/SortedAssignment.h>
#include <openplx/SymbolTree.h>

namespace openplx {
    /**
     * Implements [Kahn's algorithm](https://www.youtube.com/watch?v=cIBFEhD77b4) to produce a sorted topological order of assignments.
     *
     */
    class TopologicalSort {
        public:

            /**
             * Runs kahns algorithm using the GetSortedNodesVisitor and UpdateDegreeVisitor, stores the result in the model declaration.
             *
             * @param model_declaration Input/Output: The model declaration that is the scope of the sort, the result can be extracted using getTopologicalsort() on model_declaration.
             * @param nodes Input: The model declarations (including param1 to this method) and var declarations that is in scope.
             * @param error_reporter Output: The error reporter. Should be checked by caller!
             */
            static void sortForModelDeclaration(
                    const ModelDeclPtr& model_declaration,
                    const SymTreePtr& symbol_tree,
                    const std::shared_ptr<ErrorReporter>& error_reporter);
    };
}
