#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/GravitationalField.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model PointGravitationalField */
namespace openplx::Simulation {
    /**
     *     PointGravitationalField calculates a gravity which is uniform in magnitude over the entire
     *     environment, but the direction of the force will point towards the center position given.
     *     A negative magnitude will result in a force pushing from the center.
     *     center - center position of the field. All gravitational forces will point to or from this
     *              position
     *     magnitude - the magnitude of the gravitational force
     *     */
    class PointGravitationalField : public openplx::Simulation::GravitationalField {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_center;
            double m_magnitude;

        public:
            PointGravitationalField();
            std::shared_ptr<openplx::Math::Vec3> center() const;
            double magnitude() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
