#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Interactions/Mate.h>
/* Generated code for model Joint */
namespace openplx::Robotics::Joints {
    class Joint : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::Mate> m_mate;
            std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>> m_links;

        public:
            Joint();
            std::shared_ptr<openplx::Physics3D::Interactions::Mate> mate() const;
            std::vector<std::shared_ptr<openplx::Robotics::Links::RigidLink>> links() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
