#pragma once

#include <filesystem>
#include <ostream>
#include <openplx/OpenPlxContextInternal.h>
#include <openplx/BundleConfig.h>
#include <openplx/Type.h>

namespace openplx
{
    class PyiGenerator
    {
        public:

            PyiGenerator(std::string package);

            void generate(
                openplx::Core::Api::OpenPlxContextInternal& openplx_context,
                Bundle::BundleConfig& bundle_config,
                const std::filesystem::path& output_path
            );

            void generate_for_document(
                const std::shared_ptr<openplx::Document>& document,
                std::ostream& os
            );

        private:
            std::string to_py_type_hint(const std::shared_ptr<openplx::Type>& type) const;

            std::string m_package;
    };
}
