#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics3D/Signals/Position3DOutputTrait.h>
/* Generated code for model Position3DOutput */
namespace openplx::Physics3D::Signals {
    /**
     * A 3D position output given an interaction.
     * For interactions where it is unambiguous which position is requested,
     * the output will give the current output value.
     **/
    class Position3DOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics3D::Signals::Position3DOutputTrait> m_source;

        public:
            Position3DOutput();
            std::shared_ptr<openplx::Physics3D::Signals::Position3DOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
