#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Input.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DInputTrait.h>
/* Generated code for model LinearVelocity3DInput */
namespace openplx::Physics3D::Signals {
    /**
     * A vec3 as linear velocity input.
     * For models which have an unambiguous 3D linear velocity input parameter.
     * The input is given as a 3D velocity vector in the world coordinate system, expressed in absolute coordinates.
     **/
    class LinearVelocity3DInput : public openplx::Physics::Signals::Input {
        protected:
            std::weak_ptr<openplx::Physics3D::Signals::LinearVelocity3DInputTrait> m_source;

        public:
            LinearVelocity3DInput();
            std::shared_ptr<openplx::Physics3D::Signals::LinearVelocity3DInputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
