#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Interactions/Interaction.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultMateDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultMateFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultMateToughness.h>
#include <openplx/Physics3D/Interactions/Clearance/DefaultMateClearance.h>
/* Generated code for model Mate */
namespace openplx::Physics3D::Interactions {
    /**
     *     A mate is a two body interaction which is defined from two MateConnectors.
     *     The MateConnector define three axes, main_axis, normal and cross, which define an orthonormal basis.
     *     The degrees of freedom of the mates are defined using these axes.
     *     For each degree of freedom the mate can have individually specified
     *     damping, deformation, breakableness and slack.
     *     */
    class Mate : public openplx::Physics::Interactions::Interaction {
        protected:
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation> m_dissipation;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility> m_flexibility;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness> m_toughness;
            std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance> m_clearance;
            bool m_enable_snap;

        public:
            Mate();
            std::vector<std::shared_ptr<openplx::Physics3D::Charges::MateConnector>> charges() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultMateDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultMateFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultMateToughness> toughness() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Clearance::DefaultMateClearance> clearance() const;
            bool enable_snap() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
