#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Bodies/Kinematics.h>
#include <openplx/Math/AffineTransform.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model RigidBodyKinematics */
namespace openplx::Physics3D::Bodies {
    /**
     * local_cm_transform: Relative local_transform
     * initial_local_linear_velocity: local linear velocity relative the body parent system
     * initial_local_angular_velocity: local angular velocity relative the body parent system
     **/
    class RigidBodyKinematics : public openplx::Physics3D::Bodies::Kinematics {
        protected:
            std::shared_ptr<openplx::Math::AffineTransform> m_local_cm_transform;
            std::shared_ptr<openplx::Math::Vec3> m_initial_local_linear_velocity;
            std::shared_ptr<openplx::Math::Vec3> m_initial_local_angular_velocity;

        public:
            RigidBodyKinematics();
            std::shared_ptr<openplx::Math::AffineTransform> local_cm_transform() const;
            std::shared_ptr<openplx::Math::Vec3> initial_local_linear_velocity() const;
            std::shared_ptr<openplx::Math::Vec3> initial_local_angular_velocity() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
