#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Physics/Signals/TorqueRangeOutputTrait.h>
/* Generated code for model TorqueRangeOutput */
namespace openplx::Physics::Signals {
    /**
     * A torque range output given an interaction.
     * For interactions where it is unambiguous which torque range is requested,
     * the output will give the current output value.
     **/
    class TorqueRangeOutput : public openplx::Physics::Signals::Output {
        protected:
            std::weak_ptr<openplx::Physics::Signals::TorqueRangeOutputTrait> m_source;

        public:
            TorqueRangeOutput();
            std::shared_ptr<openplx::Physics::Signals::TorqueRangeOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
